<?php

if (!defined('_PS_VERSION_'))
	exit;
	
class BlockBestSellers_carousel extends Module
{
	private $_html = '';
	private $_postErrors = array();

	public function __construct()
	{
		$this->name = 'blockbestsellers_carousel';
		$this->tab = 'front_office_features';
		$this->version = '1.0';
		$this->author = 'Promokit Co.';
		$this->need_instance = 0;

		parent::__construct();

		$this->displayName = $this->l('Top seller carousel');
		$this->description = $this->l('Add a block displaying the shop\'s top sellers as vertical carousel.');
	}

	/**
	 * @see ModuleCore::install()
	 */
	public function install()
	{
		if (!parent::install() ||
				!$this->registerHook('rightColumn') ||
				!$this->registerHook('header') ||
				!$this->registerHook('updateOrderStatus') ||
				!ProductSale::fillProductSales())
			return false;
		return true;
	}

	/**
	 * Called in administration -> module -> configure
	 */
	public function getContent()
	{
		$output = '<h2>'.$this->displayName.'</h2>';
		if (Tools::isSubmit('submitBestSellers'))
		{
			Configuration::updateValue('PS_BLOCK_BESTSELLERS_DISPLAY', (int)(Tools::getValue('always_display')));
			$output .= '<div class="conf confirm">'.$this->l('Settings updated').'</div>';
		}
		return $output.$this->displayForm();
	}

	public function getAverageGrade($pid) {		

		$validate = Configuration::get('PRODUCT_COMMENTS_MODERATE');

		return Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow('
		SELECT (SUM(pc.`grade`) / COUNT(pc.`grade`)) AS grade
		FROM `'._DB_PREFIX_.'product_comment` pc
		WHERE pc.`id_product` = '.(int)$pid.'
		AND pc.`deleted` = 0'.
		($validate == '1' ? ' AND pc.`validate` = 1' : ''));

	}

	public static function getCommentNumber($pid)
	{
		if (!Validate::isUnsignedId($pid))
			die(Tools::displayError());
		$validate = (int)Configuration::get('PRODUCT_COMMENTS_MODERATE');
		if (($result = Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow('
		SELECT COUNT(`id_product_comment`) AS "nbr"
		FROM `'._DB_PREFIX_.'product_comment` pc
		WHERE `id_product` = '.(int)($pid).($validate == '1' ? ' AND `validate` = 1' : ''))) === false)
			return false;
		return (int)($result['nbr']);
	}

	public function displayForm()
	{
		return '
		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post">
			<fieldset>
				<legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this->l('Settings').'</legend>
				<label>'.$this->l('Always display block').'</label>
				<div class="margin-form">
					<input type="radio" name="always_display" id="display_on" value="1" '.(Tools::getValue('always_display', Configuration::get('PS_BLOCK_BESTSELLERS_DISPLAY')) ? 'checked="checked" ' : '').'/>
					<label class="t" for="display_on"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
					<input type="radio" name="always_display" id="display_off" value="0" '.(!Tools::getValue('always_display', Configuration::get('PS_BLOCK_BESTSELLERS_DISPLAY')) ? 'checked="checked" ' : '').'/>
					<label class="t" for="display_off"> <img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
					<p class="clear">'.$this->l('Show the block even if no product is available.').'</p>
				</div>
				<center><input type="submit" name="submitBestSellers" value="'.$this->l('Save').'" class="button" /></center>
			</fieldset>
		</form>';
	}
	
	public function hookRightColumn($params)
	{
		if (Configuration::get('PS_CATALOG_MODE'))
			return;
		$err = "";
		$currency = new Currency($params['cookie']->id_currency);
		$bestsellers = ProductSale::getBestSalesLight((int)($params['cookie']->id_lang), 0, 5);
		
		if (!$bestsellers && !Configuration::get('PS_BLOCK_BESTSELLERS_DISPLAY'))
			return;
		$best_sellers = array();

		if ($bestsellers)
			foreach ($bestsellers as $bestseller)
			{
				$bestseller['price'] = Tools::displayPrice(Product::getPriceStatic((int)($bestseller['id_product'])), $currency);
				$best_sellers[] = $bestseller;
			}

		if (Module::isInstalled("productcomments")) { // check if module Product Comments installed
			    // Exists		  

			    foreach ($bestsellers as $product => $value) {
			    
					$id_p = $value["id_product"];
					$p_comments_grade[$id_p] = $this->getAverageGrade($id_p);
					$p_comments_number[$id_p] = $this->getCommentNumber($id_p);

					if (empty($p_comments_grade[$id_p]['grade'])) $p_comments_grade[$id_p]['grade'] = 0; // if no rating, rating = 0

					$this->smarty->assign(array(
						'p_comments_grade' => $p_comments_grade,
						'p_comments_number' => $p_comments_number
					));
				}

			} else {
				$err .= "<div>Please install \"Product comments\" module</div>";
			}

		$this->smarty->assign(array(
			'best_sellers' => $best_sellers,
			'mediumSize' => Image::getSize('medium'),
			'smallSize' => Image::getSize('small')
		));
		return $this->display(__FILE__, 'blockbestsellers_carousel.tpl');
	}
	
	public function hookLeftColumn($params)
	{
		return $this->hookRightColumn($params);
	}

	public function hookHeader($params)
	{
		if (Configuration::get('PS_CATALOG_MODE'))
			return;		
		$this->context->controller->addCSS(($this->_path).'blockbestsellers.css', 'all');
		
		foreach ($this->context->controller->js_files as $id => $scriptName) { // get all included scipts
			$scripts[$id] = array_pop(explode("/", $scriptName));
		}
		if (!(in_array("jquery.jcarousel.js", $scripts))) {
			$this->context->controller->addJS(($this->_path).'jquery.jcarousel.js');
		}
	}
	
}


