<!-- MODULE Block best sellers carousel -->
{if $best_sellers|count >= 5}
<script>
$(function() {
    $("#best-sellers_carousel .jCarouselLite").jCarouselLite({
        btnNext: "#best-sellers_carousel .next",
        btnPrev: "#best-sellers_carousel .prev",
        speed:500,
        visible: 5,
        scroll: 1,
        auto: 4000,
        vertical: true
    });       
});
</script>
{/if}
<div id="best-sellers_carousel" class="block products_block">
	{if $best_sellers|count >= 5}
	<button class="prev"><<</button>
	<button class="next">>></button>
	{/if}
	<h4>{l s='Top sellers' mod='blockbestsellers'}</h4>
	<div class="block_content jCarouselLite">
	{if $best_sellers|@count > 0}
		<ul class="product_images">
			{foreach from=$best_sellers item=product name=myLoop}
			<li class="{if $smarty.foreach.myLoop.first}first_item{elseif $smarty.foreach.myLoop.last}last_item{else}item{/if} clearfix">
				<a href="{$product.link}" title="{$product.legend|escape:'htmlall':'UTF-8'}" class="content_img clearfix">
					<img src="{$link->getImageLink($product.link_rewrite, $product.id_image, 'small_default')}" alt="{$product.legend|escape:'htmlall':'UTF-8'}" />
				</a>
				<h5>
                <a href="{$product.link}" title="{$product.name|escape:'htmlall':'UTF-8'}">
					{$product.name|strip_tags:'UTF-8'|escape:'htmlall':'UTF-8'|truncate:25:'...'}
				</a>
                </h5>
				<p class="price">{convertPrice price=$product.price}</p>
                <div class="rate">
					<div class="rate_block">
						<div class="rate_star" style="width:{$p_comments_grade[$product['id_product']]['grade']*20}%;"></div>
					</div>
                     <p>{$p_comments_grade[$product['id_product']]['grade']}/5</p>
                 </div>
			</li>
		{/foreach}
		</ul>
	{else}
		<p>{l s='No best sellers at this time' mod='blockbestsellers'}</p>
	{/if}
	{if isset($err)}
	<p>{$err}</p>
	{/if}
	</div>
</div>
<!-- /MODULE Block best sellers carousel -->
