<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="{$lang_iso}">
	<head>
		<title>{$meta_title|escape:'htmlall':'UTF-8'}</title>
{if isset($meta_description) AND $meta_description}
		<meta name="description" content="{$meta_description|escape:html:'UTF-8'}" />
{/if}
{if isset($meta_keywords) AND $meta_keywords}
		<meta name="keywords" content="{$meta_keywords|escape:html:'UTF-8'}" />
{/if}
		<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=utf-8" />
		<meta http-equiv="content-language" content="{$meta_language}" />
		<meta name="generator" content="PrestaShop" />
		<meta name="robots" content="{if isset($nobots)}no{/if}index,{if isset($nofollow) && $nofollow}no{/if}follow" />
		<link rel="icon" type="image/vnd.microsoft.icon" href="{$favicon_url}?{$img_update_time}" />
		<link rel="shortcut icon" type="image/x-icon" href="{$favicon_url}?{$img_update_time}" />
		<script type="text/javascript">
			var baseDir = '{$content_dir}';
			var baseUri = '{$base_uri}';
			var static_token = '{$static_token}';
			var token = '{$token}';
			var priceDisplayPrecision = {$priceDisplayPrecision*$currency->decimals};
			var priceDisplayMethod = {$priceDisplay};
			var roundMode = {$roundMode};
		</script>
        {if isset($css_files)}
            {foreach from=$css_files key=css_uri item=media}
            <link href="{$css_uri}" rel="stylesheet" type="text/css" media="{$media}" />
            {/foreach}
        {/if}
        {if $page_name == "product"}
        <link href="{$css_dir}feature-carousel.css" rel="stylesheet" type="text/css" media="{$media}" />
        {/if} 
        <!--[if IE]>
        <link href="{$css_dir}arundo_ie.css" rel="stylesheet" type="text/css" />
        <![endif]-->
        {include file="$tpl_dir./settings.tpl"}
        {if isset($js_files)}
            {foreach from=$js_files item=js_uri}
            <script type="text/javascript" src="{$js_uri}"></script>
            {/foreach}
        {/if}        
		{$HOOK_HEADER}
</head>
	<body {if isset($page_name)}id="{$page_name|escape:'htmlall':'UTF-8'}"{/if} class="{if $hide_left_column}hide-left-column {/if}{if $hide_right_column}hide-right-column {/if}{if $theme_settings.column}{$theme_settings.column}_column{/if}">
		{hook h='freePosition'}				
	{if !$content_only}
		{if isset($restricted_country_mode) && $restricted_country_mode}
		<div id="restricted-country">
			<p>{l s='You cannot place a new order from your country.'} <span class="bold">{$geolocation_country}</span></p>
		</div>
		{/if}		
		<div class="preloader"></div>		
		<div id="page" class="container_9 clearfix">
			<div id="header-bg"></div>
        	<div id="page_top">
				{hook h='headertop'}
            </div><!-- #page_top -->
			<!-- Header -->
        <div id="page_block">
			<div id="header" class="grid_9 alpha omega">
				<div id="header_right" class="grid_6 omega">
                    {$HOOK_TOP}
                    <div id="logo">                        
						<a href="{$base_dir}" id="logo-image" {if isset($theme_settings.logo_type) && $theme_settings.logo_type == 1} class="hide"{/if}>
							<img class="logo" src="{$logo_url}" alt="{$shop_name|escape:'htmlall':'UTF-8'}"  />
						</a>
						<div id="logo-text" class="{if isset($theme_settings.logo_type) && $theme_settings.logo_type == 0}hide{/if}">
							<a href="{$base_dir}" class="logo" id="header_logo"
								{if isset($theme_settings.logo_color)}style="color:{$theme_settings.logo_color}; font-size:{$theme_settings.logo_size}px"{/if}>
								{if isset($theme_settings.logo_text)}
									{$theme_settings.logo_text}
								{/if}								
							</a>
							{if isset($theme_settings.slogan)}
								<span class="slogan">{$theme_settings.slogan}</span>
							{/if}				
						</div>			
                    </div><!-- #logo -->
				</div>
			</div>

			<div id="columns" class="clearfix">
				
                {*<!-- Left -->
                *{if $page_name != 'index'}
				*<div id="left_column" class="column grid_2 alpha">
				*	{$HOOK_LEFT_COLUMN}
				*</div>
                *{/if}
                *}

				<!-- Center -->
				<div id="center_column" class=" grid_5">
	{/if}
