{if isset($category)}
	{if $category->id AND $category->active}
		{if $category->description || $category->id_image}
		<script>
			$(document).ready(function(){
				$("#columns").addClass("catImage");
			});
		</script>
		{/if}
		{if $theme_settings.cat_title == 1}
		<h1>
			{strip}
				{$category->name|escape:'htmlall':'UTF-8'}
				{if isset($categoryNameComplement)}
					{$categoryNameComplement|escape:'htmlall':'UTF-8'}
				{/if}
			{/strip}
		</h1>
		{/if}
		
		{include file="$tpl_dir./breadcrumb.tpl"}
		{include file="$tpl_dir./errors.tpl"}

		{if $scenes || $category->description || $category->id_image}
		<div class="content_scene_cat">
			{if $scenes}
				<!-- Scenes -->
				{include file="$tpl_dir./scenes.tpl" scenes=$scenes}
			{else}
				<!-- Category image -->
				{if $category->id_image}
				<div class="align_center">
				<img src="{$link->getCatImageLink($category->link_rewrite, $category->id_image, 'category_default')}" alt="{$category->name|escape:'htmlall':'UTF-8'}" title="{$category->name|escape:'htmlall':'UTF-8'}" id="categoryImage" width="{$categorySize.width}" height="{$categorySize.height}" />
				</div>
				{/if}
			{/if}
			{if $theme_settings.cat_title == 1}
			{if $category->description}
				<div class="cat_desc">
					<p>{$category->description}</p>
				</div>
			{/if}
			{/if}
		</div>
		{/if}
        {if isset($subcategories)}
        {if $theme_settings.subcategories == 1}
		<!-- Subcategories -->
		<div id="subcategories">
			<h3>{l s='Subcategories'}</h3>
			<ul class="inline_list">
			{foreach from=$subcategories item=subcategory}
				<li class="clearfix">
					<a href="{$link->getCategoryLink($subcategory.id_category, $subcategory.link_rewrite)|escape:'htmlall':'UTF-8'}" title="{$subcategory.name|escape:'htmlall':'UTF-8'}" class="img">
						{if $subcategory.id_image}
							<img src="{$link->getCatImageLink($subcategory.link_rewrite, $subcategory.id_image, 'medium_default')}" alt="" width="{$mediumSize.width}" height="{$mediumSize.height}" />
						{else}
							
						{/if}
					</a>
					<a href="{$link->getCategoryLink($subcategory.id_category, $subcategory.link_rewrite)|escape:'htmlall':'UTF-8'}" class="cat_name">{$subcategory.name|escape:'htmlall':'UTF-8'}</a>
					{if $subcategory.description}
						<p class="cat_desc">{$subcategory.description}</p>
					{/if}
				</li>
			{/foreach}
			</ul>
			<br class="clear"/>
		</div>
		{/if}
		{/if}

		{if $products}
			<div class="content_sortPagiBar sortPagiBarTop">				
				<div class="sortPagiBar clearfix">
					<div class="views_float">						
						{include file="./product-sort.tpl"}
					</div>
					<div class="views">
						<div class="view_btn {if $theme_settings.view == "view_grid"}act_btn{/if}" id="view_grid" title="grid"></div>
						<div class="view_btn {if $theme_settings.view == "view_list"}act_btn{/if}" id="view_list" title="list"></div>
					</div>
					<div class="imageSize" {if $theme_settings.view == "view_list"}style="display:none"{/if}>
						<div class="view_btn {if $theme_settings.imageSize == "view_big"}act_btn{/if}" id="view_big" title="Big Images"></div>
						<div class="view_btn {if $theme_settings.imageSize == "view_small"}act_btn{/if}" id="view_small" title="Small Images"></div>
					</div>	
                    <div class="product-compare">                    	
                    	{include file="./nbr-product-page.tpl"}
						{include file="./product-compare.tpl"}
                    </div>				
				</div>
			</div>						
			<div id="listing_view" class="{if $theme_settings}{$theme_settings.view} {$theme_settings.imageSize}{/if}">
				{include file="./product-list.tpl" products=$products}
			</div>
			
			<div class="content_sortPagiBar">
				<div class="sortPagiBar clearfix">
					{include file="./product-sort_bottom.tpl"}
                    {include file="./pagination.tpl"}
				</div>
			</div>
		{/if}
	{elseif $category->id}
		<p class="warning">{l s='This category is currently unavailable.'}</p>
	{/if}
{/if}