<?php
/**
  * Twitter Widget
  * Add twitter widget to sidebar (left or right column)
  *
  * @author		: Danni Afasyah
  * @website	: http://prestanesia.com
  * @version	: 1.0
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
**/
class twitterwidget extends Module
{
	private $_html = '';
	private $_postErrors = array();
	
    public function __construct()
    {
        $this->name = 'twitterwidget';
        $this->tab = 'Blocks';
        $this->version = 1.0;

        parent::__construct();

        /* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('Twitter Widget');
        $this->description = $this->l('Twitter Widget');
		$this->full_url = _MODULE_DIR_.$this->name.'/';
		
		$config = Configuration::getMultiple(array('PS_TWITTER_USERNAME','PS_TWITTER_AVATARSIZE','PS_TWITTER_COUNT'));
		if (empty($config['PS_TWITTER_USERNAME']))
			$this->warning = $this->l('Please insert your Twitter username');		
			}

    function install()
    {
        if (!parent::install() OR !$this->registerHook('footer_twitter') OR !$this->registerHook('header') 
			OR !Configuration::updateValue('PS_TWITTER_USERNAME', 'prestashop')
			OR !Configuration::updateValue('PS_TWITTER_COUNT', '3')
			)
			return false;
		return true;
    }
	public function uninstall()
	{
		if (!Configuration::deleteByName('PS_TWITTER_USERNAME')
			OR !Configuration::deleteByName('PS_TWITTER_COUNT')
		    OR !parent::uninstall())
			return false;
		return true;
	}	
	public function hookHeader($params)
	{
		$this->context->controller->addCSS(($this->_path).'jquery.tweet.css', 'all');
		$this->context->controller->addJS(($this->_path).'jquery.tweet.js');
		
		foreach ($this->context->controller->js_files as $id => $scriptName) { // get all included scipts
			$scripts[$id] = array_pop(explode("/", $scriptName));
		}
		if (!(in_array("jquery.jcarousel.js", $scripts))) {
			$this->context->controller->addJS(($this->_path).'jquery.jcarousel.js');
		}
	}
	
    public function hookfooter_twitter($params)
    {
		global $smarty;		
		$smarty->assign('username', Configuration::get('PS_TWITTER_USERNAME'));
		$smarty->assign('count', Configuration::get('PS_TWITTER_COUNT')+1);
		$smarty->assign('tw_this_path', $this->_path);
		return $this->display(__FILE__, 'twitterwidget.tpl');
	}

	function hookRightColumn($params)
	{
		return $this->hookfooter_twitter($params);
	}
	public function _displayForm()
	{

		$this->_html .= '
		<form  class="width2" action="'.$_SERVER['REQUEST_URI'].'" method="post" style="margin-bottom:10px;">
			<fieldset><legend style="line-height:32px"><img src="'.$this->_path.'logo.png" alt="" title="" />'.$this->l('Settings').'</legend>
				<label>'.$this->l('Twitter username').'</label>
				<div class="margin-form"><input type="text" name="twitterusername" id="twitterusername" value="'.Configuration::get('PS_TWITTER_USERNAME').'" size="50">
					<p class="clear">'.$this->l('Twitter Username').'</p>
				</div>
				<label>'.$this->l('Tweet\'s count').'</label>
				<div class="margin-form"><input type="text" name="count" id="count" value="'.Configuration::get('PS_TWITTER_COUNT').'" size="50" >
					<p class="clear">'.$this->l('Tweet\'s Count').'</p>
				</div>												
				<br /><center><input type="submit" name="btnSetting" value="'.$this->l('Save').'" class="button" /></center>
			</fieldset>
		</form>
		';
	}
	private function _postValidation()
	{
		if (isset($_POST['btnSetting']))
		{
			if (empty($_POST['twitterusername']))
				$this->_postErrors[] = '<p>'.$this->l('Please insert your Twitter username').'</p>';
			if (empty($_POST['count']))
				$this->_postErrors[] = '<p>'.$this->l('Please insert number of tweets displayed').'</p>';					
//			echo '<div class="conf confirm">'.$this->l('Configuration updated').'</div>';
					
		}
	}	
	private function _postProcess()
	{
		if(isset($_POST['btnSetting']))
		{
	 		Configuration::updateValue('PS_TWITTER_USERNAME', $_POST['twitterusername']);
			Configuration::updateValue('PS_TWITTER_COUNT', $_POST['count']);
			$this->_html .= '<div class="conf confirm">'.$this->l('Settings Saved').'</div>';
		}
		
	}	
	public function getContent()
	{
		$this->_html = '<h2>'.$this->displayName.'</h2>';
		if (Tools::isSubmit('btnSetting'))	
		//if (!empty($_POST) || isset($_GET['delete']) )
		{

			$this->_postValidation();
			if (!sizeof($this->_postErrors))
				$this->_postProcess();					
			else
				foreach ($this->_postErrors AS $err)
					$this->_html .= '<div class="alert error">'. $err .'</div>';
				$this->_html .= '<br><p><a href="javascript:history.back(1)" class="button">'.$this->l('back').'</a></p>';
		}
		else $this->_displayForm();
		return $this->_html;
	}	
	
}

?>
