// Cycle plugin config
jQuery(document).ready(function($){

    var c3TransitionType = "scrollRight";
    var c3Autostop = 0;
    var c3Speed = 700;
    var c3Timeout = 5000;
    var c3Sync = 0;

        
        // Cover the scenario of having only one slide
        if ( $("#c3-slider > li").size() == 1 ) {
            if ( c3Autostop == 1 ) {
                // sliding image
                $('#c3-slider').find('.sliding-image').css({'display':'block'}).delay(50).animate({'left':'10px', 'opacity':1}, { duration: "100", easing: "easeOutCirc" });
                // sliding text
                $('#c3-slider').find('.sliding-text').css({'display':'block'}).delay(250).animate({'right':'10px', 'opacity':1}, { duration: "100", easing: "easeOutCirc" });
            } else {
                // Clone the first slide (only if there's one slide) to be able to initiate the transision effects
                $('#c3-slider li:eq(0)').clone().insertAfter('#c3-slider li:eq(0)');
            }
        }
        
    /* homepage slider params */
    $('#c3-slider').cycle({
        fx:         c3TransitionType,
        easing:              'easeOutCirc',
        autostop:           c3Autostop,
        before:     onBefore,
        after:      onAfter,
        speed:      c3Speed,
        timeout:        c3Timeout,
        sync:       c3Sync,
        randomizeEffects:   0,
        prev:       '#slider-prev',
        next:       '#slider-next',
        pager:      '#c3-nav'
    });
        
    function onBefore(curr, next, opts, fwd) {
            // sliding image
            $(next).find('.sliding-image').css({'display':'none', 'left':'-1009px', 'opacity':0});
            // sliding text
            $(next).find('.sliding-text').css({'display':'none', 'right':'-1009px', 'opacity':0});
            
    }
    function onAfter(curr, next, opts, fwd) {
            // sliding image
            $(this).find('.sliding-image').css({'display':'block'}).delay(50).animate({'left':'0px', 'opacity':1}, { duration: 'slow', easing: "easeOutBack" });
            // sliding text
        $(this).find('.sliding-text').css({'display':'block'}).delay(50).animate({'right':'0px', 'opacity':1}, { duration: 'slow', easing: "easeOutBack" });}

    $('#c3-pauseButton').click(function() {
        $('#c3-slider').cycle('pause');
        return false;
    });

    $('#c3-resumeButton').click(function() {
        $('#c3-slider').cycle('resume', true);
        return false;
    });

});




