<?php
/**
 * $ModDesc
 * 
 * @version		1.1.1
 * @package		modules
 * @copyright	Copyright (C) March 2012 http://promokit.eu <@email:support@promokit.eu>. All rights reserved.
 * @license		GNU General Public License version 2
 */
if (!defined('_PS_VERSION_'))
	exit;

require (dirname(__FILE__).'/menuitems.php');

class themesettings extends Module
{

	public $pattern = '/^([A-Z_]*)[0-9]+/';
	public $page_name = '';

	public function __construct()
	{
		$this->name = 'themesettings';
		$this->tab = 'Other';
		$this->version = '1.1.1';
		$this->author = 'Promokit Co.';
		$this->need_instance = 0;
		$this->maxSize = 81;

		parent::__construct();

		$this->displayName = $this->l('Theme Settings module');
		$this->description = $this->l('Add extended theme settings');

		$this->patternsQuantity = 24;

		$this->defaultFonts = array(
			"logo" => "Agor",
			"buttons" => "FranklinGothicBook",
			"headings" => "FranklinGothicBook",
			"text" => "Arial",
		);

		$this->selectors = array(
			"logo" => "a.logo",			
			"headings" => "#page h1, #page h2, #page h3, #page h4, #page h5, #page h6",			
			"text" => "#page p",
			"links" => "#page a",
			"bg" => "#footer, #header-bg",
			"buttons" => "#page input.button_mini, #page input.button_small, #page input.button, #page input.button_large, #page input.button_mini_disabled, #page input.button_small_disabled, #page input.button_disabled, #page input.button_large_disabled, #page input.exclusive_mini, #page input.exclusive_small, #page input.exclusive, #page input.exclusive_large, #page input.exclusive_mini_disabled, #page input.exclusive_small_disabled, #page input.exclusive_disabled, #page input.exclusive_large_disabled, #page a.button_mini, #page a.button_small, #page a.button, #page a.button_large, #page a.exclusive_mini, #page a.exclusive_small, #page a.exclusive, #page a.exclusive_large, #page span.button_mini, #page span.button_small, #page span.button, #page span.button_large, #page span.exclusive_mini, #page span.exclusive_small, #page span.exclusive, #page span.exclusive_large, #page span.exclusive_large_disabled",
			"buttons_hover" => "#page input.button_mini:hover, #page input.button_small:hover, #page input.button:hover, #page input.button_large:hover, #page input.exclusive_mini:hover, #page input.exclusive_small:hover, #page input.exclusive:hover, #page input.exclusive_large:hover, #page a.button_mini:hover, #page a.button_small:hover, #page a.button:hover, #page a.button_large:hover, #page a.exclusive_mini:hover, #page a.exclusive_small:hover, #page a.exclusive:hover, #page a.exclusive_large:hover",
			"logo_admin" => "#logofont_example",
			"headings_admin" => ".tabcontent #heading-example h5",
			"text_admin" => ".tabcontent #text-example",
			"links_admin" => ".tabcontent #link-example a",
			"custom_heading" => "#page #right_column h4, #page #productsCarousel h4, #page #bestsellersCarousel h4",
			"additionalBg" => "#footer #footer_twitter, #search_top .block_content",
		);

		$this->defaultSettings = array(
			"listing_view" => 0,
			"productImageSize" => 0,
			"sett_panel" => 1,
			"logo_type" => 1,
			"logo_text" => "Arundo",
			"slogan" => "The lowest prices on the web",
			"pattern" => 22,
			"back_color" => "#303135",
			"logo_color" => "#3a3a3c",
			"headings_color" => "#333333",
			"buttons_color" => "#ffffff",
			"buttons_text_color" => "#43433f",
			"buttons_hover_color" => "#ffffff",
			"buttons_hover_text_color" => "#43433f",
			"buttons_font" => $this->defaultFonts["buttons"],
			"links_color" => "#aaaaaa",
			"hover_links_color" => "#888888",
			"text_color" => "#bbbbbb",
			"logo_size" => 30,
			"logo_font" => $this->defaultFonts["logo"],
			"heading_font" => $this->defaultFonts["headings"],
			"text_font" => $this->defaultFonts["text"],
			"column" => "right",
			"toTop" => 1,
			"tooltips" => 1,
			"back_image" => "",
			"back_position" => "center",
			"back_repeat" => "repeat",
			"tab_number" => 1,
			"category_title" => 0,
			"subcategories" => 0,
			"product_page" => 0,
			"use_menuicons" => 1
			);
		$this->bImage = "";
		$this->errors = "";
		$this->noImage = "No image selected";
		$this->settingsFile = $this->local_path."css/customsettings".(int)Context::getContext()->shop->id.".css";		

	}


	public function install()
	{

		if (parent::install() && 
			$this->registerHook('displayHeader') &&
			$this->registerHook('displayAdminHomeQuickLinks') &&			
			$this->registerHook('freePosition'))
		{
			/* Sets up configuration */
			$res = Configuration::updateValue('TS_PRODUCT_LV', $this->defaultSettings["listing_view"]);
			$res &= Configuration::updateValue('TS_IMAGE_SIZES', $this->defaultSettings["productImageSize"]);
			$res &= Configuration::updateValue('TS_SETT_PANEL', $this->defaultSettings["sett_panel"]);
			$res &= Configuration::updateValue('TS_LOGO_TYPE', $this->defaultSettings["logo_type"]);
			$res &= Configuration::updateValue('TS_LOGO_TEXT', $this->defaultSettings["logo_text"]);
			$res &= Configuration::updateValue('TS_SLOGAN', $this->defaultSettings["slogan"]);
			$res &= Configuration::updateValue('TS_PATTERN', $this->defaultSettings["pattern"]);
			$res &= Configuration::updateValue('TS_BACK_COLOR', $this->defaultSettings["back_color"]);
			$res &= Configuration::updateValue('TS_LOGO_COLOR', $this->defaultSettings["logo_color"]);
			$res &= Configuration::updateValue('TS_HEAD_COLOR', $this->defaultSettings["headings_color"]);
			$res &= Configuration::updateValue('TS_BUTTONS_COLOR', $this->defaultSettings["buttons_color"]);
			$res &= Configuration::updateValue('TS_BUTTONS_TXT_COL', $this->defaultSettings["buttons_text_color"]);
			$res &= Configuration::updateValue('TS_BUTTONS_HVR_COLOR', $this->defaultSettings["buttons_hover_color"]);
			$res &= Configuration::updateValue('TS_BUTTONS_HVR_TXT_COL', $this->defaultSettings["buttons_hover_text_color"]);
			$res &= Configuration::updateValue('TS_BUTTONS_FONT', $this->defaultSettings["buttons_font"]);
			$res &= Configuration::updateValue('TS_LINKS_COLOR', $this->defaultSettings["links_color"]);
			$res &= Configuration::updateValue('TS_HVR_LINKS_COLOR', $this->defaultSettings["hover_links_color"]);
			$res &= Configuration::updateValue('TS_TEXT_COLOR', $this->defaultSettings["text_color"]);
			$res &= Configuration::updateValue('TS_LOGO_SIZE', $this->defaultSettings["logo_size"]);
			$res &= Configuration::updateValue('TS_LOGO_FONT', $this->defaultSettings["logo_font"]);
			$res &= Configuration::updateValue('TS_HEADING_FONT', $this->defaultSettings["heading_font"]);
			$res &= Configuration::updateValue('TS_TEXT_FONT', $this->defaultSettings["text_font"]);
			$res &= Configuration::updateValue('TS_COLUMN', $this->defaultSettings["column"]);
			$res &= Configuration::updateValue('TS_TOTOP', $this->defaultSettings["toTop"]);
			$res &= Configuration::updateValue('TS_TOOLTIPS', $this->defaultSettings["tooltips"]);
			$res &= Configuration::updateValue('TS_BACK_IMAGE', $this->defaultSettings["back_image"]);
			$res &= Configuration::updateValue('TS_BACK_POS', $this->defaultSettings["back_position"]);
			$res &= Configuration::updateValue('TS_BACK_RPT', $this->defaultSettings["back_repeat"]);
			$res &= Configuration::updateValue('TS_TAB_NUM', $this->defaultSettings["tab_number"]);
			$res &= Configuration::updateValue('TS_CAT_TITLE', $this->defaultSettings["category_title"]);
			$res &= Configuration::updateValue('TS_SUBCAT', $this->defaultSettings["subcategories"]);
			$res &= Configuration::updateValue('TS_PRODUCT_PAGE', $this->defaultSettings["product_page"]);
			$res &= Configuration::updateValue('TS_MENU_ICONS', $this->defaultSettings["use_menuicons"]);
			$res &= Configuration::updateValue('TS_CUSTOM_CSS', "");

			return $res;
		}
		return false;
	}

	public function fontslist() {
		include_once(dirname(__FILE__).'/fontlist.php');
		return get_fonts();
	}

	public function getContent()
	{	
		function is_https() {
	        return strtolower(substr($_SERVER["SERVER_PROTOCOL"],0,5))=='https'? true : false;
	    }

	    $shopUrl = is_https()?'https':'http'.'://'.$_SERVER['HTTP_HOST']. __PS_BASE_URI__;
		$themeUrl = $shopUrl.'themes/'._THEME_NAME_.'/';
				
		$this->context->controller->addJS(_PS_JS_DIR_.'jquery/plugins/jquery.colorpicker.js');
		$this->context->controller->addJS(($this->_path).'js/scripts.js'); // add JS to back office
		$this->context->controller->addCSS(($this->_path).'css/themesettings_admin.css'); // add CSS to back office		
		$this->context->controller->addCSS(($this->_path).'css/customsettings'.(int)Context::getContext()->shop->id.'.css');
		$this->context->controller->addCSS($themeUrl."css/grid_prestashop.css");		

		$msg = '';
		$err = '';
		$this->bImage = $this->noImage;				

		$mImgs = $this->showmenuicons(); // check show or hide menu icons in back office

		$output = '<h2>'.$this->displayName.'</h2>';		

		if (Tools::isSubmit('submitDeleteImgConf')) {

			if($this->context->employee->id_profile == 1) {
				// Delete the image file
				if (file_exists(_PS_MODULE_DIR_.$this->name.'/'.Configuration::get('TS_BACK_IMAGE')))
					unlink(_PS_MODULE_DIR_.$this->name.'/'.Configuration::get('TS_BACK_IMAGE'));
				
				// Update the extension to the global value or the shop group value if available
				Configuration::updateValue('TS_BACK_IMAGE',$this->defaultSettings["back_image"]);
				Configuration::updateValue('TS_TAB_NUM', (int)(Tools::getValue('tab_number')));	

				$msg .= '<div class="conf confirm">'.$this->l('Image removed').'</div>';			
				$this->bImage = $this->noImage;				

			} else {
				$msg .= '<div class="conf error">'.$this->l('Access denied').'</div>';
			}

		}
			

		if (Tools::isSubmit('resetThemeSettings'))
		{			

			Configuration::updateValue('TS_PRODUCT_LV', $this->defaultSettings["listing_view"]);
			Configuration::updateValue('TS_IMAGE_SIZES', $this->defaultSettings["productImageSize"]);
			Configuration::updateValue('TS_SETT_PANEL', $this->defaultSettings["sett_panel"]);
			Configuration::updateValue('TS_LOGO_TYPE', $this->defaultSettings["logo_type"]);
			Configuration::updateValue('TS_LOGO_TEXT', $this->defaultSettings["logo_text"]);
			Configuration::updateValue('TS_SLOGAN', $this->defaultSettings["slogan"]);
			Configuration::updateValue('TS_PATTERN', $this->defaultSettings["pattern"]);
			Configuration::updateValue('TS_BACK_COLOR', $this->defaultSettings["back_color"]);
			Configuration::updateValue('TS_LOGO_COLOR', $this->defaultSettings["logo_color"]);
			Configuration::updateValue('TS_HEAD_COLOR', $this->defaultSettings["headings_color"]);
			Configuration::updateValue('TS_BUTTONS_COLOR', $this->defaultSettings["buttons_color"]);
			Configuration::updateValue('TS_BUTTONS_TXT_COL', $this->defaultSettings["buttons_text_color"]);
			Configuration::updateValue('TS_BUTTONS_HVR_COLOR', $this->defaultSettings["buttons_hover_color"]);
			Configuration::updateValue('TS_BUTTONS_HVR_TXT_COL', $this->defaultSettings["buttons_hover_text_color"]);
			Configuration::updateValue('TS_BUTTONS_FONT', $this->defaultSettings["buttons_font"]);
			Configuration::updateValue('TS_LINKS_COLOR', $this->defaultSettings["links_color"]);
			Configuration::updateValue('TS_HVR_LINKS_COLOR', $this->defaultSettings["hover_links_color"]);
			Configuration::updateValue('TS_TEXT_COLOR', $this->defaultSettings["text_color"]);
			Configuration::updateValue('TS_LOGO_SIZE', $this->defaultSettings["logo_size"]);
			Configuration::updateValue('TS_LOGO_FONT', $this->defaultSettings["logo_font"]);
			Configuration::updateValue('TS_HEADING_FONT', $this->defaultSettings["heading_font"]);	
			Configuration::updateValue('TS_TEXT_FONT', $this->defaultSettings["text_font"]);
			Configuration::updateValue('TS_COLUMN', $this->defaultSettings["column"]);
			Configuration::updateValue('TS_TOTOP', $this->defaultSettings["toTop"]);
			Configuration::updateValue('TS_TOOLTIPS', $this->defaultSettings["tooltips"]);
			Configuration::updateValue('TS_BACK_IMAGE', $this->defaultSettings["back_image"]);
			Configuration::updateValue('TS_BACK_POS', $this->defaultSettings["back_position"]);
			Configuration::updateValue('TS_BACK_RPT', $this->defaultSettings["back_repeat"]);
			Configuration::updateValue('TS_TAB_NUM', $this->defaultSettings["tab_number"]);	
			Configuration::updateValue('TS_CAT_TITLE', $this->defaultSettings["category_title"]);
			Configuration::updateValue('TS_SUBCAT', $this->defaultSettings["subcategories"]);
			Configuration::updateValue('TS_PRODUCT_PAGE', $this->defaultSettings["product_page"]);
			Configuration::updateValue('TS_MENU_ICONS', $this->defaultSettings["use_menuicons"]);
			Configuration::updateValue('TS_CUSTOM_CSS', "");
			$this->bImage = $this->noImage;
			$this->cssWriter();
			$msg = '<div class="conf confirm">'.$this->l('Settings reseted').'</div>';
		}				
		
		if (Tools::isSubmit('back_image_upload')) {	

			if($this->context->employee->id_profile == 1) {		

				if (isset($_FILES['back_image']) && isset($_FILES['back_image']['tmp_name']) && !empty($_FILES['back_image']['tmp_name']))
				{

					if ($error = ImageManager::validateUpload($_FILES['back_image'], Tools::convertBytes(ini_get('upload_max_filesize'))))
						$this->errors = $error;

					if ($this->errors == "Image format not recognized, allowed formats are: .gif, .jpg, .png") $this->errors = "Images extension wrong!";
						
					elseif ($dot_pos = strrpos($_FILES['back_image']['name'], '.'))
					{

						$this->adv_imgname = 'background_image';
						$ext = substr($_FILES['back_image']['name'], $dot_pos + 1);
						$newname = 'background_image'.'-'.(int)$this->context->shop->id;
						if (!move_uploaded_file($_FILES['back_image']['tmp_name'], _PS_MODULE_DIR_.$this->name.'/'.$newname.'.'.$ext))
							$this->errors .= $this->l('Error move uploaded file');
						else
							$this->adv_imgname = $newname;

						Configuration::updateValue('TS_BACK_IMAGE', $this->adv_imgname.'.'.$ext);					
								
					}

				}
				if (Configuration::get('TS_BACK_IMAGE') != "")
				{
					$this->bImage = '<img class="back_image" src="'.$this->context->link->protocol_content.Tools::getMediaServer($this->name)._MODULE_DIR_.$this->name."/".Configuration::get('TS_BACK_IMAGE').'" />';		
				}
				else {			
					$this->bImage = $this->noImage;	
				}
				Configuration::updateValue('TS_TAB_NUM', (int)(Tools::getValue('tab_number')));							

				if ($this->errors) { $errors = '<div class="conf error">'.$this->errors.'</div>'; } else $errors = "";
				$msg .= $errors.'<div class="conf confirm">'.$this->l('Settings updated').'</div>';			
			} else {
				$msg .= '<div class="conf error">'.$this->l('Access denied').'</div>';			
			}

		}

		if (Tools::isSubmit('submitThemeSettings'))
		{
			if($this->context->employee->id_profile == 1) {
			
				Configuration::updateValue('TS_PRODUCT_LV', (int)(Tools::getValue('view')));
				Configuration::updateValue('TS_SETT_PANEL', (int)(Tools::getValue('sett_panel')));
				Configuration::updateValue('TS_LOGO_TYPE', (int)(Tools::getValue('logo_type')));
				Configuration::updateValue('TS_LOGO_TEXT', (string)(Tools::getValue('logo_text')));
				Configuration::updateValue('TS_SLOGAN', (string)(Tools::getValue('slogan')));
				Configuration::updateValue('TS_PATTERN', (int)(Tools::getValue('pattern')));
				Configuration::updateValue('TS_BACK_COLOR', (string)(Tools::getValue('back_color')));
				Configuration::updateValue('TS_LOGO_COLOR', (string)(Tools::getValue('logo_color')));
				Configuration::updateValue('TS_HEAD_COLOR', (string)(Tools::getValue('headings_color')));
				Configuration::updateValue('TS_BUTTONS_COLOR', (string)(Tools::getValue('buttons_color')));
				Configuration::updateValue('TS_BUTTONS_TXT_COL', (string)(Tools::getValue('buttons_text_color')));
				Configuration::updateValue('TS_BUTTONS_HVR_COLOR', (string)(Tools::getValue('buttons_hover_color')));
				Configuration::updateValue('TS_BUTTONS_HVR_TXT_COL', (string)(Tools::getValue('buttons_hover_text_color')));
				Configuration::updateValue('TS_BUTTONS_FONT', (string)(Tools::getValue('buttons_font')));
				Configuration::updateValue('TS_LINKS_COLOR', (string)(Tools::getValue('links_color')));
				Configuration::updateValue('TS_HVR_LINKS_COLOR', (string)(Tools::getValue('hover_links_color')));
				Configuration::updateValue('TS_LOGO_SIZE', (string)(Tools::getValue('logo_size')));
				Configuration::updateValue('TS_LOGO_FONT', (string)(Tools::getValue('logo_font')));
				Configuration::updateValue('TS_HEADING_FONT', (string)(Tools::getValue('heading_font')));		
				Configuration::updateValue('TS_TEXT_FONT', (string)(Tools::getValue('text_font')));
				Configuration::updateValue('TS_TEXT_COLOR', (string)(Tools::getValue('text_color')));
				Configuration::updateValue('TS_COLUMN', (string)(Tools::getValue('column')));
				Configuration::updateValue('TS_TOTOP', (int)(Tools::getValue('toTop')));
				Configuration::updateValue('TS_TOOLTIPS', (int)(Tools::getValue('tooltips')));
				Configuration::updateValue('TS_BACK_POS', (string)(Tools::getValue('back_position')));
				Configuration::updateValue('TS_BACK_RPT', (string)(Tools::getValue('back_repeat')));
				Configuration::updateValue('TS_IMAGE_SIZES', (string)(Tools::getValue('productImageSize')));
				Configuration::updateValue('TS_TAB_NUM', (int)(Tools::getValue('tab_number')));	
				Configuration::updateValue('TS_CAT_TITLE', (int)(Tools::getValue('cat_title')));
				Configuration::updateValue('TS_SUBCAT', (int)(Tools::getValue('subcategories')));
				Configuration::updateValue('TS_PRODUCT_PAGE', (int)(Tools::getValue('product_page')));
				Configuration::updateValue('TS_MENU_ICONS', (int)(Tools::getValue('use_menuicons')));
				Configuration::updateValue('TS_CUSTOM_CSS', (string)(Tools::getValue('customcss')));	

				// ######## write settings to file
							
				$this->cssWriter();
				$mImgs = $this->showmenuicons("upload"); // check show or hide menu icons in back office
				
				$this->bImage = "";			
				if (Configuration::get('TS_BACK_IMAGE') != "")
				{
					$this->bImage = '<img class="back_image" src="'.$this->context->link->protocol_content.Tools::getMediaServer($this->name)._MODULE_DIR_.$this->name."/".Configuration::get('TS_BACK_IMAGE').'" />';		
				}
				else {			
					$this->bImage = $this->noImage;	
				}

				if ($this->errors) { $errors = '<div class="conf error">'.$this->errors.'</div>'; } else $errors = "";
				$msg .= $errors.'<div class="conf confirm">'.$this->l('Settings updated').'</div>';	
			} else {
				$msg .= '<div class="conf error">'.$this->l('Access denied').'</div>';	
			}
					
		}
		return $output.$this->displayForm($msg, $this->bImage, $mImgs);
		
	}

	public function showmenuicons($param = "read") { // get path and image name
		if (Configuration::get('TS_MENU_ICONS') == 1) {
			$menuItemImages = $this->fullpath($param);
			$smi_mImgs = $this->menuImages($menuItemImages["fullpath"], $menuItemImages["name"]);
		} else {
			$smi_mImgs = "";
		}
		return $smi_mImgs;
	}

	public function fullpath($controller) { // get path and image name

		$menuItemsNumber = 0;
		$menu = MenuItems::makeMenu(); // get number of menu items

		foreach ($menu as $key=>$item) {

			$menuItemsNumber++;

			$menuItemImages["name"][$key] = $item;
			if ($controller == "upload") {
				if ((int)(Tools::getValue('removeItem_'.$key)) == 1 && Configuration::get('TS_MENUITEM_ICON_'.$key) != "") {
					$this->imageRemove('TS_MENUITEM_ICON_'.$key);
				} else {
					if (Tools::getValue('menuitem_'.$key)) {
						Configuration::updateValue('TS_MENUITEM_ICON_'.$key, (string)(Tools::getValue('menuitem_'.$key)));
					}
				}
			}			
			$menuItemImages["fullpath"][$key] = MenuItems::imageUpload("menuitem_".$key, $key, $controller);
		}			

		return $menuItemImages;

	}

	public function menuImages($menu, $names) { // generate html code for back office

		$menu_items = "";
		$rev = date("H").date("i").date("s")."\n";
		
		foreach ($menu as $key=>$item) {
			if ($item["name"] == $this->noImage) {
				$item["name"] = "noimg.png";
			}
			$menu_items .= "<li>			
			<div class=\"itemImage\"><img src=\"".$item['path'].$item['name']."?".$rev."\" /><br />".$names[$key]."</div>
			<input class=\"itemInput\" id=\"menuitem_".$key."\" type=\"file\" name=\"menuitem_".$key."\"><br />
			<input type=\"checkbox\" name=\"removeItem_".$key."\" id=\"removeItem_".$key."\" class=\"removeicon\" value=\"0\" />
			<label for=\"removeItem_".$key."\" class=\"removeicon_title\">Remove Icon</label>
			<script>$('.removeicon').click(function(){ $('#removeItem_".$key."').val( this.checked ? '1' : '0' );})</script>
			</li>";			
		}
		
		return $menu_items;

	}

	public function imageRemove($pointer) {

		$msg = "";
		if($this->context->employee->id_profile == 1) {

			// Delete the image file
			$file = _PS_MODULE_DIR_.$this->name.'/menuicons/'.Configuration::get($pointer); // get image file name
			if (file_exists($file)) unlink($file); // delete file

			// Update the extension to the global value or the shop group value if available
			Configuration::updateValue($pointer, "");	// remove image name from database

			$msg .= '<div class="conf confirm">'.$this->l('Image removed').'</div>';			

		} else {
			$msg .= '<div class="conf error">'.$this->l('Access denied').'</div>';
		}

		return $msg;
	}

	function fontNameAdaptation($name) {
		return str_replace( ' ', '+', $name ); 
	}

	public function cssWriter() {

		if (!$fileHolder = @fopen($this->settingsFile, 'w')) {
			$this->errors .= "Can't open settings file!";
		} else {				
			if (fwrite($fileHolder, $this->cssGenerator()) === FALSE) {
				$this->errors .= "Can't write settings!";
			}
			fclose($fileHolder);
		}

	}

	public function cssGenerator() {			

		if (Configuration::get('TS_BACK_IMAGE') == "") {
			$bg = "
				background-image: url(../images/patterns/back_".Configuration::get('TS_PATTERN').".png); 
				background-repeat: repeat; background-position: 50% 0; 
				background-color: ".Configuration::get('TS_BACK_COLOR');		
		} else {
			$bg = "
				background-image: url(../".Configuration::get('TS_BACK_IMAGE')."); 
				background-repeat:".Configuration::get('TS_BACK_RPT')."; 
				background-position:".Configuration::get('TS_BACK_POS')." top; 
				background-color: ".Configuration::get('TS_BACK_COLOR');
		}				

		$css = "";
		$css .= $this->selectors["logo"].", ".$this->selectors["logo_admin"] ." {
				font-size:".Configuration::get('TS_LOGO_SIZE')."px; 
				font-family:\"".Configuration::get('TS_LOGO_FONT')."\"; 
				color:".Configuration::get('TS_LOGO_COLOR')."}\n";
		$css .= $this->selectors["buttons"]." {
				background-color: ".Configuration::get('TS_BUTTONS_COLOR')."; 
				color: ".Configuration::get('TS_BUTTONS_TXT_COL')."; 
				font-family: \"".Configuration::get('TS_BUTTONS_FONT')."\"}\n";
		$css .= $this->selectors["buttons_hover"]." {
				background-color: ".Configuration::get('TS_BUTTONS_HVR_COLOR')."; 
				color: ".Configuration::get('TS_BUTTONS_HVR_TXT_COL')."}\n";
		$css .= $this->selectors["headings"].", ".$this->selectors["headings_admin"]." {
				font-family: \"".Configuration::get('TS_HEADING_FONT')."\"; 
				color: ".Configuration::get('TS_HEAD_COLOR')."}\n";
		$css .= $this->selectors["text"].", ".$this->selectors["text_admin"]." {
				font-family: \"".Configuration::get('TS_TEXT_FONT')."\"; 
				color: ".Configuration::get('TS_TEXT_COLOR')."}\n";
		$css .= $this->selectors["links"].", ".$this->selectors["links_admin"]." {
					color: ".Configuration::get('TS_LINKS_COLOR')."}\n"
				.$this->selectors["links_admin"].":hover{
					color: ".Configuration::get('TS_HVR_LINKS_COLOR')."}\n";
		/*		##### 		temporary styles 		####	*/
		$css .= $this->selectors["bg"]." {".$bg."}\n";
		$css .= "#footer #footer_twitter, #search_top .block_content { 
				background-color:".Configuration::get('TS_BACK_COLOR')."}\n";
		$css .= $this->selectors["custom_heading"]." {
				font-family: \"".Configuration::get('TS_HEADING_FONT')."\"; 
				color: ".Configuration::get('TS_HEAD_COLOR')."}";
		$css .= "#page #right_column h4 a, #page #customlinks li a, #page #productsCarousel a.f_title, #page #bestsellersCarousel a.f_title {
				color: ".Configuration::get('TS_LINKS_COLOR')."}";
		$css .= "#page_block a:hover, #page #right_column h4 a:hover, #page #customlinks li a:hover, #page #productsCarousel a.f_title:hover, #page #bestsellersCarousel a.f_title:hover {
				color:".Configuration::get('TS_HVR_LINKS_COLOR')."}\n";

		if (Configuration::get('TS_MENU_ICONS') == 1) {
			
			$pathArray = $this->fullpath("read");

			foreach ($pathArray["fullpath"] as $key => $value) {
				if ($value["name"] != $this->noImage) 
					$css .= ".show_icons .menuitem_".$key." div.ic { background-image: url(../menuicons/".$value["name"]."); }\n";
			}
		}

		$css .= Configuration::get('TS_CUSTOM_CSS');
		return $css;
	}

	public function optionList($fontType)	{  // create a <option> list for <select>

		$fontsOption = "";
		foreach ($this->fontslist() as $key => $font) { // get fonts list
			if ($fontType == $font) {
				$selected = "selected";
			} else {
				$selected = "";
			}
			$fontsOption .= '<option '.$selected.' value="'.$font.'">'.$font.'</option>';					   
		}
		return $fontsOption;

	}

	public function displayForm($message, $image, $mImages)
	{				
		$sett_str = $styles = "";
		for ($i = 0; $i < $this->patternsQuantity; $i++) { // get patterns

			if (Configuration::get('TS_PATTERN') == $i) {
				$checked = "checked=\"maxchecked\"";
				$ptClass = "selected";
			} else {
				$checked = "";
				$ptClass = "";
			}
			if ($i == 0) {
				$title = "title=\"don't use pattern\"";
			} else {$title = "";}
			$sett_str .= "<label ".$title." for=\"back_".$i."\" class=\"cell back_".$i." ".$ptClass."\" onclick=\"$('#ptrns label').removeClass('selected');$(this).addClass('selected');\">							
			<input type=\"radio\" id=\"back_".$i."\" name=\"pattern\" value=\"".$i."\" class=\"var\" $checked /></label>";
		}

		$fonts = $this->optionList(Configuration::get('TS_LOGO_FONT'));
		$h_fonts = $this->optionList(Configuration::get('TS_HEADING_FONT'));		
		$text_fonts = $this->optionList(Configuration::get('TS_TEXT_FONT'));
		$buttons_fonts = $this->optionList(Configuration::get('TS_BUTTONS_FONT'));
		
		$sizes = "";
		for ($i = 15; $i < $this->maxSize; $i++) {
			if (Configuration::get('TS_LOGO_SIZE') == $i) {
				$selected = "selected";
			} else {
				$selected = "";
			}
			$sizes .= '<option '.$selected.' value="'.$i.'">'.$i.'px</option>';	
		}
		
		$tabNum = Configuration::get('TS_TAB_NUM');
		$link_params = "rel=\"stylesheet\" type=\"text/css\" href=\"http://fonts.googleapis.com/css?family=";
		$fontFiles = "";

		/*	####	if not default font, include it ####	*/
		if (!(in_array(Configuration::get('TS_LOGO_FONT'), $this->defaultFonts))) {
		$fontFiles .= "<link id=\"logofont_link\" ".$link_params.$this->fontNameAdaptation(Configuration::get('TS_LOGO_FONT'))."\">";
		}
		if (!(in_array(Configuration::get('TS_HEADING_FONT'), $this->defaultFonts))) {
		$fontFiles .= "<link id=\"headingsfont_style\" ".$link_params.$this->fontNameAdaptation(Configuration::get('TS_HEADING_FONT'))."\">";
		}
		if (!(in_array(Configuration::get('TS_TEXT_FONT'), $this->defaultFonts))) {
			$fontFiles .= "<link id=\"textfont_style\" ".$link_params.$this->fontNameAdaptation(Configuration::get('TS_TEXT_FONT'))."\">";
		}	
		if (!(in_array(Configuration::get('TS_BUTTONS_FONT'), $this->defaultFonts))) {
			$fontFiles .= "<link id=\"buttonsfont_style\" ".$link_params.$this->fontNameAdaptation(Configuration::get('TS_BUTTONS_FONT'))."\">";
		}	

		return $fontFiles.'
		<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" enctype="multipart/form-data" class="list_options" id="themesettings ts-prefix" method="post">
			<fieldset>
				<div class="tabscontainer">
					<div class="heading">
						<div class="module-title">
						<img src="'.$this->_path.'logo.png" width="16" height="16" alt="" title="" />'.$this->l('Theme Settings').'
						</div>
						<div class="buttons_section">
							'.$message.'
							<input type="submit" name="resetThemeSettings" value="'.$this->l('Reset Settings').'" class="button" id="reset_sett" />
							<input type="submit" name="submitThemeSettings" value="'.$this->l('Apply Settings').'" class="button" />
						</div>
					</div>
					<div class="tabs">						
						<div class="tab '.(($tabNum == 1) ? 'selected' : '').'" id="tab_menu_1">
				             <div class="link">General Settings</div>
				             <div class="arrow"></div>
				        </div>
				        <div class="tab '.(($tabNum == 2) ? 'selected' : '').'" id="tab_menu_2">
				             <div class="link">Background</div>
				             <div class="arrow"></div>
				        </div>
				        <div class="tab '.(($tabNum == 3) ? 'selected' : '').'" id="tab_menu_3">
				             <div class="link">Logo</div>
				             <div class="arrow"></div>
				        </div>					        
				        <div class="tab '.(($tabNum == 4) ? 'selected' : '').'" id="tab_menu_4">
				             <div class="link">Buttons</div>
				             <div class="arrow"></div>
				        </div>
				        <div class="tab '.(($tabNum == 5) ? 'selected' : '').'" id="tab_menu_5">
				             <div class="link">Text</div>
				             <div class="arrow"></div>
				        </div>
				        <div class="tab '.(($tabNum == 6) ? 'selected' : '').'" id="tab_menu_6">
				             <div class="link">Category Page</div>
				             <div class="arrow"></div>
				        </div>
				        <div class="tab '.(($tabNum == 7) ? 'selected' : '').'" id="tab_menu_7">
				             <div class="link">Product Page</div>
				             <div class="arrow"></div>
				        </div>
				        <div class="tab '.(($tabNum == 8) ? 'selected' : '').'" id="tab_menu_8">
				             <div class="link">Custom Styles</div>
				             <div class="arrow"></div>
				        </div>
				        <div class="tab '.(($tabNum == 9) ? 'selected' : '').'" id="tab_menu_9">
				             <div class="link">Menu Icons</div>
				             <div class="arrow"></div>
				        </div>
			        </div>			        
					<div class="curvedContainer">					
						<div class="tabcontent" id="tab_content_1" '.(($tabNum == 1) ? 'style="display:block"' : '').'">
						<input type="radio" class="hide" name="tab_number" id="tab_1" value="1" '.(($tabNum == 1) ? 'checked="checked"' : '').' />
						<div class="va-content">
							<div class="margin form">
								<h4>Settings Panel on the front page</h4>								
								<div class="variant">
									<input type="radio" name="sett_panel" id="settpanel_on" value="1" '.((Configuration::get('TS_SETT_PANEL') == 1) ? 'checked="checked" ' : '').'/>
									<label class="t" for="settpanel_on">Show</label>
								</div>
								<div class="variant">
									<input type="radio" name="sett_panel" id="settpanel_off" value="0" '.((Configuration::get('TS_SETT_PANEL') == 0) ? 'checked="checked" ' : '').'/>
									<label class="t" for="settpanel_off">Hide</label>									
								</div>
							</div>														
							<div class="margin form" id="page-layout">
								<h4>Page Layout</h4>
								<div class="variant tt-wrapper">
									<label class="illustrated '.((Configuration::get('TS_COLUMN') == "left") ? 'selected' : '').'" for="left_col" onclick="$(\'#page-layout label\').removeClass(\'selected\');$(this).addClass(\'selected\');">
										<img src="'.$this->_path.'/images/backoffice/col_left.gif" alt="" />
										<input class="invisible" type="radio" id="left_col" name="column" value="left" '.((Configuration::get('TS_COLUMN') == "left") ? 'checked="checked" ' : '').'/>
										<span class="tt">Left Column + Center Column</span>
									</label>
									<label class="illustrated '.((Configuration::get('TS_COLUMN') == "right") ? 'selected' : '').'" for="right_col" onclick="$(\'#page-layout label\').removeClass(\'selected\');$(this).addClass(\'selected\');">
										<img src="'.$this->_path.'/images/backoffice/col_right.gif" alt="" />
										<input class="invisible" type="radio" name="column" id="right_col" value="right" '.((Configuration::get('TS_COLUMN') == "right") ? 'checked="checked" ' : '').'/>
										<span class="tt">Center Column + Right Column</span>
									</label>
									<div class="clear"></div>
								</div>															
							</div>
							<div class="margin form">
								<h4>Scroll to Top Button</h4>
								<div class="variant">
									<input type="radio" id="scroll_totop_on" name="toTop" value="1" '.((Configuration::get('TS_TOTOP') == 1) ? 'checked="checked" ' : '').'/>
									<label class="t" for="scroll_totop_on">Show</label>
								</div>							
								<div class="variant">		
									<input type="radio" name="toTop" id="scroll_totop_off" value="0" '.((Configuration::get('TS_TOTOP') == 0) ? 'checked="checked" ' : '').'/>
									<label class="t" for="scroll_totop_off">Hide</label>
								</div>								
							</div>
							<div class="margin form">
								<h4>Stylized Tooltips</h4>
								<div class="variant">
									<input type="radio" id="tooltips_on" name="tooltips" value="1" '.((Configuration::get('TS_TOOLTIPS') == 1) ? 'checked="checked" ' : '').'/>
									<label class="t" for="tooltips">Enable</label>
								</div>							
								<div class="variant">		
									<input type="radio" name="tooltips" id="tooltips_off" value="0" '.((Configuration::get('TS_TOOLTIPS') == 0) ? 'checked="checked" ' : '').'/>
									<label class="t" for="tooltips_off">Disable</label>
								</div>								
							</div>
							<div class="margin form">
								<h4>Category title and description on the category page</h4>								
								<div class="variant">
									<input type="radio" name="cat_title" id="cat_title_on" value="1" '.((Configuration::get('TS_CAT_TITLE') == 1) ? 'checked="checked" ' : '').'/>
									<label class="t" for="cat_title_on">Show</label>
								</div>
								<div class="variant">
									<input type="radio" name="cat_title" id="cat_title_off" value="0" '.((Configuration::get('TS_CAT_TITLE') == 0) ? 'checked="checked" ' : '').'/>
									<label class="t" for="cat_title_off">Hide</label>									
								</div>
							</div>
						</div>
					</div>
					<div class="tabcontent" id="tab_content_2" '.(($tabNum == 2) ? 'style="display:block"' : '').'>
					<input type="radio" class="hide" name="tab_number" id="tab_2" value="2" '.(($tabNum == 2) ? 'checked="checked"' : '').' />
						<div class="va-content">
							<div class="margin form">
								<h4>Background Color</h4>								
								<div class="variant">
									<input type="color" name="back_color" id="back_color" class="colorpicker" data-hex="true" value="'.Configuration::get('TS_BACK_COLOR').'" />									
									<label class="t textinput" for="back_color"></label><br />
								</div>
								<br/>
								<h4>Background Image</h4>
								<div class="variant">
									<div class="back_image_container">
										'.$image.'
									</div>									
									<input id="back_image" type="file" name="back_image">
									<input id="bimage" type="submit" class="button" name="back_image_upload">
									<input class="button '.(($image == $this->noImage) ? 'hide' : '').'" type="submit" name="submitDeleteImgConf" value="'.$this->l('Delete image').'" />
								</div>
								<div class="'.(($image == $this->noImage) ? 'hide' : '').'">
									<h4>Background Position</h4>
									<div class="labels-wrapper variant tt-wrapper" id="backpos">
										<label class="illustrated_medium '.((Configuration::get('TS_BACK_POS') == "left") ? 'selected' : '').'" for="back_position_left" onclick="$(\'#backpos label\').removeClass(\'selected\');$(this).addClass(\'selected\');">
											<img src="'.$this->_path.'/images/backoffice/back_left.gif" alt="" />
											<input class="invisible" type="radio" name="back_position" id="back_position_left" value="left" '.((Configuration::get('TS_BACK_POS') == "left") ? 'checked="checked" ' : '').'/>
											<span class="tt">Left Top</span>
										</label>
										<label class="illustrated_medium '.((Configuration::get('TS_BACK_POS') == "center") ? 'selected' : '').'" for="back_position_center" onclick="$(\'#backpos label\').removeClass(\'selected\');$(this).addClass(\'selected\');">
											<img src="'.$this->_path.'/images/backoffice/back_center.gif" alt="" />
											<input class="invisible" type="radio" name="back_position" id="back_position_center" value="center" '.((Configuration::get('TS_BACK_POS') == "center") ? 'checked="checked" ' : '').'/>
											<span class="tt">Center Top</span>
										</label>
										<label class="illustrated_medium '.((Configuration::get('TS_BACK_POS') == "right") ? 'selected' : '').'" for="back_position_right" onclick="$(\'#backpos label\').removeClass(\'selected\');$(this).addClass(\'selected\');">
											<img src="'.$this->_path.'/images/backoffice/back_right.gif" alt="" />
											<input class="invisible" type="radio" name="back_position" id="back_position_right" value="right" '.((Configuration::get('TS_BACK_POS') == "right") ? 'checked="checked" ' : '').'/>
											<span class="tt">Right Top</span>
										</label>
										<div class="clear"></div>
									</div>
									<h4>Background Repeat</h4>
									<div class="labels-wrapper variant tt-wrapper" id="backrepeat">
										<label class="illustrated_small '.((Configuration::get('TS_BACK_RPT') == "no-repeat") ? 'selected' : '').'" for="back_rpt_no" onclick="$(\'#backrepeat label\').removeClass(\'selected\');$(this).addClass(\'selected\');">
											<img src="'.$this->_path.'/images/backoffice/rpt-no.gif" alt="" />
											<input class="invisible" type="radio" name="back_repeat" id="back_rpt_no" value="no-repeat" '.((Configuration::get('TS_BACK_RPT') == "no-repeat") ? 'checked="checked" ' : '').'/>
											<span class="tt">No Repeat</span>
										</label>
										<label class="illustrated_small '.((Configuration::get('TS_BACK_RPT') == "repeat-x") ? 'selected' : '').'" for="back_rpt_x" onclick="$(\'#backrepeat label\').removeClass(\'selected\');$(this).addClass(\'selected\');">
											<img src="'.$this->_path.'/images/backoffice/rpt_x.gif" alt="" />
											<input class="invisible" type="radio" name="back_repeat" id="back_rpt_x" value="repeat-x" '.((Configuration::get('TS_BACK_RPT') == "repeat-x") ? 'checked="checked" ' : '').'/>
											<span class="tt">Repeat Horizontally</span>
										</label>
										<label class="illustrated_small '.((Configuration::get('TS_BACK_RPT') == "repeat-y") ? 'selected' : '').'" for="back_rpt_y" onclick="$(\'#backrepeat label\').removeClass(\'selected\');$(this).addClass(\'selected\');">
											<img src="'.$this->_path.'/images/backoffice/rpt_y.gif" alt="" />
											<input class="invisible" type="radio" name="back_repeat" id="back_rpt_y" value="repeat-y" '.((Configuration::get('TS_BACK_RPT') == "repeat-y") ? 'checked="checked" ' : '').'/>
											<span class="tt">Repeat Vertically</span>
										</label>
										<label class="illustrated_small '.((Configuration::get('TS_BACK_RPT') == "repeat") ? 'selected' : '').'" for="back_rpt" onclick="$(\'#backrepeat label\').removeClass(\'selected\');$(this).addClass(\'selected\');">
											<img src="'.$this->_path.'/images/backoffice/rpt.gif" alt="" />
											<input class="invisible" type="radio" name="back_repeat" id="back_rpt" value="repeat" '.((Configuration::get('TS_BACK_RPT') == "repeat") ? 'checked="checked" ' : '').'/>
											<span class="tt">Repeat All</span>
										</label>									
										<div class="clear"></div>
									</div>
									<div class="info">If you want to use predefined pattern, please remove background image</div>
								</div>
								<br/>
								<div class="'.(($image == $this->noImage) ? '' : 'hide').'">
									<h4>Patterns</h4>
									<div class="sect labels-wrapper" id="ptrns">
										'.( $sett_str ).'
										<div class="clear"></div>
									</div>	
								</div>
							</div>
						</div>
					</div>
					<div class="tabcontent" id="tab_content_3" '.(($tabNum == 3) ? 'style="display:block"' : '').'>
						<input type="radio" class="hide" name="tab_number" id="tab_3" value="3" '.(($tabNum == 3) ? 'checked="checked"' : '').' />
						<div class="va-content">
							<div class="margin form">
								<h4>Logo type</h4>		
								<div class="variant">						
									<input type="radio" name="logo_type" id="logo_type_image" value="0" '.((Configuration::get('TS_LOGO_TYPE') == 0) ? 'checked="checked" ' : '').'/>
									<label class="t" for="logo_type_image">Image</label>
								</div>
								<div class="variant">
									<input type="radio" name="logo_type" id="logo_type_text" value="1" '.((Configuration::get('TS_LOGO_TYPE') == 1) ? 'checked="checked" ' : '').'/>
									<label class="t" for="logo_type_text">Text</label>
								</div>
								<br />
								<div id="logotype-text" '.((Configuration::get('TS_LOGO_TYPE') == 0) ? 'class="hide" ' : '').'>															
									<div class="variant">
										<input type="text" size="20" name="logo_text" id="logo_text" value="'.Configuration::get('TS_LOGO_TEXT').'" />
										<label class="t textinput" for="logo_text">Shop Name</label>
									</div>	
									<div class="variant">
										<input type="text" size="20" name="slogan" id="slogan" value="'.Configuration::get('TS_SLOGAN').'" />
										<label class="t textinput" for="slogan">Shop Slogan</label>
										<br/>
									</div>
									<div class="variant">
									<input type="color" name="logo_color" id="logo_color" class="colorpicker" data-hex="true" value="'.Configuration::get('TS_LOGO_COLOR').'" />
									</div>
									<label class="t" for="logo_font">Font:</label>
									<select name="logo_font" id="logofont">'.( $fonts ).'</select>
									<label class="t" for="logo_size">Size:</label>
									<select name="logo_size" id="logosize">'.( $sizes ).'</select>			
									<br/><br/>																						
									<div class="font-sample">
										<span id="logofont_example">'.Configuration::get('TS_LOGO_TEXT').'</span>
										<span id="sloganfont_example">'.Configuration::get('TS_SLOGAN').'</span>
									</div>
								</div>
								<div id="logotype-image" '.((Configuration::get('TS_LOGO_TYPE') == 1) ? 'class="hide" ' : '').'>	
									Upoad your logo <a href="index.php?controller=AdminThemes&token='.Tools::getAdminTokenLite('AdminThemes').'#conf_id_PS_LOGO" target="_blank">here:</a>					
								</div>	
							</div>
						</div>
					</div>
					<div class="tabcontent" id="tab_content_4" '.(($tabNum == 4) ? 'style="display:block"' : '').'>
					<input type="radio" class="hide" name="tab_number" id="tab_4" value="4" '.(($tabNum == 4) ? 'checked="checked"' : '').' />
						<div class="va-content">
							<div class="margin form">
								<h4>Buttons Colors</h4>
								<div class="show_area" id="page">				
									<a class="button exclusive">Example</a>
								</div>
								<div class="sect funct_area">
									<div class="variant">										
										<input type="color" name="buttons_color" class="colorpicker" data-hex="true" id="buttons_color" value="'.Configuration::get('TS_BUTTONS_COLOR').'" />
										<label class="t textinput" for="buttons_color">Normal</label>
									</div>
									<div class="variant">										
										<input type="color" name="buttons_text_color" class="colorpicker" data-hex="true" id="buttons_text_color" value="'.Configuration::get('TS_BUTTONS_TXT_COL').'" />
										<label class="t textinput" for="buttons_text_color">Normal text</label>
									</div>
									<div class="variant">										
									<input type="color" name="buttons_hover_color" class="colorpicker" data-hex="true" id="buttons_hover_color" value="'.Configuration::get('TS_BUTTONS_HVR_COLOR').'" />
									<label class="t textinput" for="buttons_hover_color">Hover</label>
									</div>
									<div class="variant">										
										<input type="color" name="buttons_hover_text_color" class="colorpicker" data-hex="true" id="buttons_hover_text_color" value="'.Configuration::get('TS_BUTTONS_HVR_TXT_COL').'" />
										<label class="t textinput" for="buttons_hover_text_color">Hover text</label><br>
									</div>
								</div>	
								<div class="clear"></div>
								<br/>								
								<h4>Buttons Font</h4>
								<select name="buttons_font" id="buttons_font">'.( $buttons_fonts ).'</select>
							</div>
						</div>
					</div>
					<div class="tabcontent" id="tab_content_5" '.(($tabNum == 5) ? 'style="display:block"' : '').'>
					<input type="radio" class="hide" name="tab_number" id="tab_5" value="5" '.(($tabNum == 5) ? 'checked="checked"' : '').' />
						<div class="va-content">
							<div class="margin form">
								<h4>Headings</h4>
								<div class="variant">
									<div class="show_area" id="heading-example"><h5>Heading example</h5></div>
									<div class="funct_area">		
										<label class="t" for="heading_font">Font name:</label>	
										<select name="heading_font" id="heading_font">'.( $h_fonts ).'</select>						
										<input type="color" name="headings_color" class="colorpicker" data-hex="true" id="headings_color" value="'.Configuration::get('TS_HEAD_COLOR').'" />
									</div>
								</div><br/>
								<h4>Text</h4>
								<div class="variant">
									<div class="show_area" id="text-example">Lorem ipsum dolor sit amet</div>
									<div class="funct_area">		
										<label class="t" for="text_font">Font name:</label>
										<select name="text_font" id="text_font">'.( $text_fonts ).'</select>										
										<input type="color" name="text_color" class="colorpicker" data-hex="true" id="text_color" value="'.Configuration::get('TS_TEXT_COLOR').'" />
									</div>
								</div><br/>
								<h4>Links</h4>
								<div class="variant">
									<div class="show_area" id="link-example"><a>Just a link</a></div>
									<div class="funct_area">
										<div class="color_holder">											
											<div>Normal</div>
											<input type="color" name="links_color" class="colorpicker" data-hex="true" id="links_color" value="'.Configuration::get('TS_LINKS_COLOR').'" />
										</div>
										<div class="color_holder">											
											<div>Hover</div>
											<input type="color" name="hover_links_color" class="colorpicker" data-hex="true" id="hover_links_color" value="'.Configuration::get('TS_HVR_LINKS_COLOR').'" />
										</div>
									</div>
								</div>
								<div class="clear"></div>
							</div>
						</div>
					</div>
					<div class="tabcontent" id="tab_content_6" '.((Configuration::get('TS_TAB_NUM') == 6) ? 'style="display:block"' : '').'>		
					<input type="radio" class="hide" name="tab_number" id="tab_6" value="6" '.(($tabNum == 6) ? 'checked="checked"' : '').' />
						<div class="va-content tt-wrapper">

							<div class="margin form" id="product-listing">
							<h4>Listing View</h4>								
								<label class="illustrated '.((Configuration::get('TS_PRODUCT_LV') == 1) ? 'selected' : '').'" for="view_list" onclick="$(\'#product-listing label\').removeClass(\'selected\');$(this).addClass(\'selected\');" id="view_list_lbl">
									<img src="'.$this->_path.'/images/backoffice/view_list.gif" alt="" />
									<input class="invisible" type="radio" id="view_list" name="view" value="1" '.((Configuration::get('TS_PRODUCT_LV') == 1) ? 'checked="checked" ' : '').'/>
									<span class="tt">List View</span>
								</label>
								<label class="illustrated '.((Configuration::get('TS_PRODUCT_LV') == 0) ? 'selected' : '').'" for="view_grid" onclick="$(\'#product-listing label\').removeClass(\'selected\');$(this).addClass(\'selected\');" id="view_grid_lbl">
										<img src="'.$this->_path.'/images/backoffice/view_grid.gif" alt="" />
										<input class="invisible" type="radio" name="view" id="view_grid" value="0" '.((Configuration::get('TS_PRODUCT_LV') == 0) ? 'checked="checked" ' : '').'/>
										<span class="tt">Grid View</span>
								</label>
								<div class="clear"></div>
								<div>Show the product listing as a grid or a list view</div>
							</div>

							<div class="margin form '.((Configuration::get('TS_PRODUCT_LV') == 1) ? 'hide' : '').'" id="images">
							<h4>Product Image Size</h4>
								
								<label class="illustrated '.((Configuration::get('TS_IMAGE_SIZES') == 1) ? 'selected' : '').'" for="images_big" onclick="$(\'#images label\').removeClass(\'selected\');$(this).addClass(\'selected\');">
									<img src="'.$this->_path.'/images/backoffice/image_big.gif" alt="" />
									<input class="invisible" type="radio" id="images_big" name="productImageSize" value="1" '.((Configuration::get('TS_IMAGE_SIZES') == 1) ? 'checked="checked" ' : '').'/>
									<span class="tt">Big Product Images / 3 per row</span>
								</label>
								<label class="illustrated '.((Configuration::get('TS_IMAGE_SIZES') == 0) ? 'selected' : '').'" for="images_small" onclick="$(\'#images label\').removeClass(\'selected\');$(this).addClass(\'selected\');">
										<img src="'.$this->_path.'/images/backoffice/image_small.gif" alt="" />
										<input class="invisible" type="radio" name="productImageSize" id="images_small" value="0" '.((Configuration::get('TS_IMAGE_SIZES') == 0) ? 'checked="checked" ' : '').'/>
										<span class="tt">Small Product Images / 4 per row</span>
								</label>
								<div class="clear"></div>
								<div>Choose between 3 or 4 products per row</div>
							</div>
						</div>
						<div class="va-content tt-wrapper">
							<div class="margin form" id="subcategories">
								<h4>Show subcategories</h4>								
								<div class="variant">
									<input type="radio" name="subcategories" id="show_subcat" value="1" '.((Configuration::get('TS_SUBCAT') == 1) ? 'checked="checked" ' : '').'/>
									<label class="t" for="show_subcat">Show</label>
								</div>
								<div class="variant">
									<input type="radio" name="subcategories" id="hide_subcat" value="0" '.((Configuration::get('TS_SUBCAT') == 0) ? 'checked="checked" ' : '').'/>
									<label class="t" for="hide_subcat">Hide</label>									
								</div>
							</div>
						</div>
					</div>		
					<div class="tabcontent" id="tab_content_7" '.((Configuration::get('TS_TAB_NUM') == 7) ? 'style="display:block"' : '').'>		
					<input type="radio" class="hide" name="tab_number" id="tab_7" value="7" '.(($tabNum == 7) ? 'checked="checked"' : '').' />
						<div class="va-content tt-wrapper">
							<div class="margin form" id="product-appearance">
							<h4>Product Image Appearence</h4>								
								<label class="illustrated '.((Configuration::get('TS_PRODUCT_PAGE') == 1) ? 'selected' : '').'" for="view_serialscroll" onclick="$(\'#product-appearance label\').removeClass(\'selected\');$(this).addClass(\'selected\');" id="view_serialscroll_lbl">
									<img src="'.$this->_path.'/images/backoffice/view_serialscroll.gif" alt="" />
									<input class="invisible" type="radio" id="view_serialscroll" name="product_page" value="1" '.((Configuration::get('TS_PRODUCT_PAGE') == 1) ? 'checked="checked" ' : '').'/>
									<span class="tt">SerialScroll carousel</span>
								</label>
								<label class="illustrated '.((Configuration::get('TS_PRODUCT_PAGE') == 0) ? 'selected' : '').'" for="view_feat_carousel" onclick="$(\'#product-appearance label\').removeClass(\'selected\');$(this).addClass(\'selected\');" id="view_grid_lbl">
										<img src="'.$this->_path.'/images/backoffice/view_feat_carousel.gif" alt="" />
										<input class="invisible" type="radio" name="product_page" id="view_feat_carousel" value="0" '.((Configuration::get('TS_PRODUCT_PAGE') == 0) ? 'checked="checked" ' : '').'/>
										<span class="tt">Feature Carousel</span>
								</label>
								<div class="clear"></div>
								<div>Show the product image as "Feature Carousel" or "serialScroll carousel"</div>
							</div>
						</div>
					</div>
					<div class="tabcontent" id="tab_content_8" '.((Configuration::get('TS_TAB_NUM') == 8) ? 'style="display:block"' : '').'>		
					<input type="radio" class="hide" name="tab_number" id="tab_8" value="8" '.(($tabNum == 8) ? 'checked="checked"' : '').' />
						<div class="va-content tt-wrapper">
							<div class="margin form">
								<h4>Add your CSS styles</h4>
								<textarea id="customcss" name="customcss" cols="26" rows="3">'.Configuration::get('TS_CUSTOM_CSS').'</textarea>								
							</div>
						</div>
					</div>
					<div class="tabcontent" id="tab_content_9" '.((Configuration::get('TS_TAB_NUM') == 9) ? 'style="display:block"' : '').'>		
					<input type="radio" class="hide" name="tab_number" id="tab_9" value="9" '.(($tabNum == 9) ? 'checked="checked"' : '').' />
						<div class="va-content tt-wrapper">
							<div class="margin form" id="menu-icons">
								<h4>Show Icons with menu items</h4>								
								<div class="variant">
									<input type="radio" name="use_menuicons" id="icons_on" value="1" '.((Configuration::get('TS_MENU_ICONS') == 1) ? 'checked="checked" ' : '').'/>
									<label class="t" for="settpanel_on">Show</label>
								</div>
								<div class="variant">
									<input type="radio" name="use_menuicons" id="icons_off" value="0" '.((Configuration::get('TS_MENU_ICONS') == 0) ? 'checked="checked" ' : '').'/>
									<label class="t" for="settpanel_off">Hide</label>									
								</div>
							</div>
						</div>
						<div class="va-content tt-wrapper">
							<div class="margin form" id="product-listing">
								<ul class="menu-list">'.$mImages.'</ul>
								<div class="clear"></div>
							</div>
						</div>
					</div>					
				</div>
				</div>				
			</fieldset>
		</form>';
	}

	function prepareResult($control) {

		
		$view = (int)(Configuration::get('TS_PRODUCT_LV'));
		$imageSize = (int)(Configuration::get('TS_IMAGE_SIZES'));

		$sizes = array();
		for ($i = 15; $i < $this->maxSize; $i++) {
			$sizes[$i] = $i;
		}

		if ($view == 0) {
			$view = "view_grid";
		} else {
			$view = "view_list";
		}

		if ($imageSize == 0) {
			$imageSize = "view_small";
		} else {
			$imageSize = "view_big";
		}	

		$i = 0;
		foreach ($this->defaultFonts as $type => $font) {
			$dFonts[$i] = $font;
			$i++;
		}
		if(strpos($_SERVER['HTTP_USER_AGENT'], 'MSIE') !== FALSE) { $browser = "IE"; } else { $browser = ""; }

		$theme_settings = array(
			'sett_panel' => (Configuration::get('TS_SETT_PANEL')),
			'slogan' => (Configuration::get('TS_SLOGAN')),
			'logo_text' => (Configuration::get('TS_LOGO_TEXT')),
			'logo_type' => (int)(Configuration::get('TS_LOGO_TYPE')),
			'pattern' => (int)(Configuration::get('TS_PATTERN')),
			'view' => $view,
			'imageSize' => $imageSize,
			'back_color' => (Configuration::get('TS_BACK_COLOR')),
			'logo_color' => (Configuration::get('TS_LOGO_COLOR')),
			'buttons_color' => (Configuration::get('TS_BUTTONS_COLOR')),
			'buttons_text_color' => (Configuration::get('TS_BUTTONS_TXT_COL')),
			'buttons_font' => (Configuration::get('TS_BUTTONS_FONT')),
			'headings_color' => (Configuration::get('TS_HEAD_COLOR')),			
			'text_color' => (Configuration::get('TS_TEXT_COLOR')),
			'links_color' => (Configuration::get('TS_LINKS_COLOR')),
			'logo_size' => (Configuration::get('TS_LOGO_SIZE')),
			'logo_font' => $this->fontNameAdaptation(Configuration::get('TS_LOGO_FONT')),
			'heading_font' => (Configuration::get('TS_HEADING_FONT')),
			'text_font' => (Configuration::get('TS_TEXT_FONT')),
			'column' => (Configuration::get('TS_COLUMN')),
			'toTop' => (Configuration::get('TS_TOTOP')),
			'toolTips' => (Configuration::get('TS_TOOLTIPS')),
			'fonts_list' => $this->fontslist(),
			'sizes' => $sizes,
			'patternsQuantity' => $this->patternsQuantity,
			'defaultFonts' => $dFonts,
			'selectors' => $this->selectors,
			'browser' => $browser,
			'use_menuicons' => (Configuration::get('TS_MENU_ICONS')),
			'cat_title' => (Configuration::get('TS_CAT_TITLE')),
			'subcategories' => (Configuration::get('TS_SUBCAT')),
			'product_page' => (Configuration::get('TS_PRODUCT_PAGE'))
		);

		return $theme_settings;

	}

	function hookfreePosition($params) {

		$this->context->smarty->assign(
			'theme_settings', $this->prepareResult("body")
		);

		return ($this->display(__FILE__, 'themesettings.tpl'));

	}

	function hookdisplayAdminHomeQuickLinks($params) {

		echo "<li id=\"ts_block\" style=\"background:#F8F8F8 url('../modules/themesettings/logo.png') no-repeat 50% 20px\">
			<a href=\"index.php?controller=adminmodules&configure=themesettings&token=".Tools::getAdminTokenLite('AdminModules')."\">
				<h4><strong>Theme Settings</strong></h4>
				<p>Customize your theme</p>
			</a>
		</li>";
	}

	function hookHeader($params)
	{	

		$this->context->controller->addCSS(($this->_path).'css/themesettings.css', 'all');
		$this->context->controller->addCSS(($this->_path).'css/customsettings'.(int)Context::getContext()->shop->id.'.css', 'all');
		$this->context->controller->addJS(($this->_path).'js/jquery.colorpicker.js');
		$this->context->controller->addJS(($this->_path).'js/jquery.ck.js');
		$this->context->controller->addJS(($this->_path).'js/jquery.hoveraccordion.js');		
		$this->context->controller->addJS(($this->_path).'js/jquery.chosen.min.js');
		$this->context->controller->addJS(($this->_path).'js/impromtu.js');
		if (Configuration::get('TS_TOTOP') == 1) {
			$this->context->controller->addJS(_PS_JS_DIR_.'jquery/plugins/jquery.scrollTo.js');
		}
		$this->context->controller->addJS(($this->_path).'js/scripts.js');		

		$this->context->smarty->assign(
			'theme_settings', $this->prepareResult("head")
		);

		return ($this->display(__FILE__, 'scripts.tpl'));
		
	}

}