<?php
class MenuItems extends Module
{
	private $menu_items = array();

	private $pattern = '/^([A-Z_]*)[0-9]+/';		

	private function getMenuItems()
	{
		return explode(',', Configuration::get('MOD_BLOCKTOPMENU_ITEMS'));
	}

	public static function gets($id_lang, $id_linksmenutop = null, $id_shop)
	{
		$id_shop = (int)((bool) Configuration::get('PS_MULTISHOP_FEATURE_ACTIVE')) ? $id_shop : 0;

		$sql = 'SELECT l.id_linksmenutop, l.new_window, ll.link, ll.label
				FROM '._DB_PREFIX_.'linksmenutop l
				LEFT JOIN '._DB_PREFIX_.'linksmenutop_lang ll ON (l.id_linksmenutop = ll.id_linksmenutop AND ll.id_lang = '.(int)$id_lang.' AND ll.id_shop='.(int)$id_shop.')
				WHERE 1 '.((!is_null($id_linksmenutop)) ? ' AND l.id_linksmenutop = "'.(int)$id_linksmenutop.'"' : '').'
				AND l.id_shop IN (0, '.(int)$id_shop.')';

		return Db::getInstance()->executeS($sql);
	}

	public static function get($id_linksmenutop, $id_lang, $id_shop)
	{
		return self::gets($id_lang, $id_linksmenutop, $id_shop);
	}

	public function makeMenu()
	{

		$menu_raw = MenuItems::getMenuItems();				
		$id_lang = (int)Context::getContext()->language->id;
		$id_shop = (int)Shop::getContextShopID();
		
		foreach ($menu_raw as $key=>$item)
		{
			if (!$item)
				continue;
			//echo $item."\n";
			
			preg_match($this->pattern, $item, $value);
			$id = (int)substr($item, strlen($value[1]), strlen($item));
			//echo $id."\n";
			switch (substr($item, 0, strlen($value[1])))
			{
				case 'CAT':
					$id_lang = $id_lang ? (int)$id_lang : (int)Context::getContext()->language->id;
					$category = new Category((int)$id, (int)$id_lang);
					//MenuItems::getCategory((int)$id);
					$this->menu_items[$key] = $category->name;
					break;

				case 'PRD':
					$selected = ($this->page_name == 'product' && (Tools::getValue('id_product') == $id)) ? ' class="sfHover"' : '';
					$product = new Product((int)$id, true, (int)$id_lang);
					if (!is_null($product->id))
						$this->menu_items[$key] = $product->name;
					break;

				case 'CMS':
					$selected = ($this->page_name == 'cms' && (Tools::getValue('id_cms') == $id)) ? ' class="sfHover"' : '';
					$cms = CMS::getLinks((int)$id_lang, array($id));
					if (count($cms))
						$this->menu_items[$key] = $cms[0]['meta_title'];
					break;

				case 'CMS_CAT':
					$category = new CMSCategory((int)$id, (int)$id_lang);
					if (count($category))
					{
						$this->menu_items[$key] = $category->name;
					}
					break;

				case 'MAN':
					$manufacturer = new Manufacturer((int)$id, (int)$id_lang);
					if (!is_null($manufacturer->id))
					{
						if (intval(Configuration::get('PS_REWRITING_SETTINGS')))
							$manufacturer->link_rewrite = Tools::link_rewrite($manufacturer->name, false);
						else
							$manufacturer->link_rewrite = 0;
						$link = new Link;
						$this->menu_items[$key] = $manufacturer->name;
					}
					break;

				case 'SUP':
					$supplier = new Supplier((int)$id, (int)$id_lang);
					if (!is_null($supplier->id))
					{
						$link = new Link;
						$this->menu_items[$key] = $supplier->name;
					}
					break;

				case 'SHOP':
					$shop = new Shop((int)$id);
					if (Validate::isLoadedObject($shop))
					{						
						$link = new Link;
						$this->menu_items[$key] = $shop->name;
					}
					break;
				case 'LNK':
					$link = MenuItems::get((int)$id, (int)$id_lang, (int)$id_shop);
					if (count($link))
					{
						if (!isset($link[0]['label']) || ($link[0]['label'] == ''))
						{
							$default_language = Configuration::get('PS_LANG_DEFAULT');
							$link = MenuItems::get($link[0]['id_linksmenutop'], $default_language, (int)Shop::getContextShopID());
						}
						$this->menu_items[$key] = $link[0]['label'];
					}
					break;
			}

		}
		return $this->menu_items;
	}	

	public function imageUpload($imgName, $id, $ctrl)
	{
		$msg = "";
		$menuArray = array();

		if ($ctrl == "upload") {		
		if (isset($_FILES[$imgName]) && isset($_FILES[$imgName]['tmp_name']) && !empty($_FILES[$imgName]['tmp_name']))
			{

				if ($error = ImageManager::validateUpload($_FILES[$imgName], Tools::convertBytes(ini_get('upload_max_filesize'))))
					$this->errors = $error;

				if ($this->errors == "Image format not recognized, allowed formats are: .gif, .jpg, .png") $this->errors = "Images extension wrong!";
					
				elseif ($dot_pos = strrpos($_FILES[$imgName]['name'], '.'))
				{

					$this->adv_imgname = 'menuitemimg_'.$id;
					$ext = substr($_FILES[$imgName]['name'], $dot_pos + 1);
					$newname = 'menuitem_'.$id.'_img';					
					if (!move_uploaded_file($_FILES[$imgName]['tmp_name'], _PS_MODULE_DIR_.$this->name.'/menuicons/'.$newname.'.'.$ext))
						$this->errors .= $this->l('Error move uploaded file');
					else
						$this->adv_imgname = $newname;

					Configuration::updateValue('TS_MENUITEM_ICON_'.$id, $newname.'.'.$ext);					
							
				}

			}
		}

		$mImage = "";
		$menuArray["path"] = $this->context->link->protocol_content.Tools::getMediaServer($this->name)._MODULE_DIR_.$this->name."/menuicons/";
		if (Configuration::get('TS_MENUITEM_ICON_'.$id) != "")
		{
			$mImage = '<img class="menuitemimg" src="'.$this->context->link->protocol_content.Tools::getMediaServer($this->name)._MODULE_DIR_.$this->name."/menuicons/".Configuration::get('TS_MENUITEM_ICON_'.$id).'" />';				
			$menuArray["name"] = Configuration::get('TS_MENUITEM_ICON_'.$id);
		}
		else {			
			$mImage = $this->noImage;
			$menuArray["name"] = $this->noImage;	
		}							

		if ($this->errors) { $errors = '<div class="conf error">'.$this->errors.'</div>'; } else $errors = "";
		$msg .= $errors.'<div class="conf confirm">'.$this->l('Settings updated').'</div>';			

		return $menuArray;
			
	}			

}
?>