<?php
/*
	Module Name: BlockFacebookLike
	Version: 1.0
	Author: Marek Mnishek
	Author URI: http://promokit.eu
	Copyright (C) 2012 promokit.eu 

*/

if (!defined('_CAN_LOAD_FILES_'))
	exit;

class blockfacebooklike extends Module
{
	private $_html = '';
	private $_postErrors = array();
	
// -----------------------------------------------------------------

	public function __construct()
	{
		$this->name = 'blockfacebooklike';
		$this->tab = 'front_office_features';
		$this->version = '1.0';
		$this->author = 'promokit.eu';

		parent::__construct();

		$this->displayName = $this->l('Facebook Like Box');
		$this->description = $this->l('Put your Facebook fan page like box on your site.');
	}
	
// -----------------------------------------------------------------

	public function install()
	{
		if (!parent::install() OR !$this->registerHook('footer') OR
		!Configuration::updateValue('PLLB_URL', 'https://www.facebook.com/prestashop') OR
		//!Configuration::updateValue('PLLB_RENDERING', 'xfbml') OR
		!Configuration::updateValue('PLLB_WIDTH', 220) OR
		!Configuration::updateValue('PLLB_HEIGHT', 210) OR
		!Configuration::updateValue('PLLB_COLOR', 'light') OR
		!Configuration::updateValue('PLLB_BORDER', 'ccc') OR
		!Configuration::updateValue('PLLB_FACES', 'true') OR
		//!Configuration::updateValue('PLLB_STREAM', 'true') OR
		//!Configuration::updateValue('PLLB_HEADER', 'true') OR
		!Configuration::updateValue('PLLB_USE_LOCALE', 'false') OR
		!Configuration::updateValue('PLLB_LOCALE', 'en_US'))
			return false;
		return true;
	}

	public function uninstall()
	{
		if (!parent::uninstall() OR
		!Configuration::deleteByName('PLLB_URL') OR
		//!Configuration::deleteByName('PLLB_RENDERING') OR
		!Configuration::deleteByName('PLLB_WIDTH') OR
		!Configuration::deleteByName('PLLB_HEIGH') OR
		!Configuration::deleteByName('PLLB_COLOR') OR
		!Configuration::deleteByName('PLLB_BORDER') OR		
		!Configuration::deleteByName('PLLB_FACES') OR
		//!Configuration::deleteByName('PLLB_STREAM') OR
		//!Configuration::deleteByName('PLLB_HEADER') OR
		!Configuration::deleteByName('PLLB_USE_LOCALE') OR
		!Configuration::deleteByName('PLLB_LOCALE'))
			return false;
		return true;
	}
// -----------------------------------------------------------------

	private function _postValidation()
	{
		if (!Validate::isAbsoluteUrl(Tools::getValue('url')))
			$this->_postErrors[] = $this->l('The URL you entered was not valid, sorry');
		if (!Validate::isInt(Tools::getValue('width')))
			$this->_postErrors[] = $this->l('The Width value you entered was not valid, sorry');
		if (!Validate::isInt(Tools::getValue('height')))
			$this->_postErrors[] = $this->l('The Height value you entered was not valid, sorry');
	}
	
	private function _postProcess()
	{
		Configuration::updateValue('PLLB_URL', Tools::getValue('url'));
		//Configuration::updateValue('PLLB_RENDERING', Tools::getValue('rendering'));
		Configuration::updateValue('PLLB_WIDTH', Tools::getValue('width'));		
		Configuration::updateValue('PLLB_HEIGHT', Tools::getValue('height'));		
		Configuration::updateValue('PLLB_COLOR', Tools::getValue('color'));		
		Configuration::updateValue('PLLB_BORDER', Tools::getValue('border'));		
		Configuration::updateValue('PLLB_FACES', Tools::getValue('faces'));		
		//Configuration::updateValue('PLLB_STREAM', Tools::getValue('stream'));		
		//Configuration::updateValue('PLLB_HEADER', Tools::getValue('header'));		
		Configuration::updateValue('PLLB_USE_LOCALE', Tools::getValue('use_locale'));		
		Configuration::updateValue('PLLB_LOCALE', Tools::getValue('locale'));		
		
		$this->_html .= '<div class="conf confirm">'.$this->l('Settings updated').'</div>';
	}
	
	public function getContent()
	{
		$this->_html .= '<h2>'.$this->displayName.'</h2>';
		
		if (Tools::isSubmit('submit'))
		{			
			$this->_postValidation();
			
			if (!sizeof($this->_postErrors))
				$this->_postProcess();
			else
			{
				foreach ($this->_postErrors AS $err)
				{
					$this->_html .= '<div class="alert error">'.$err.'</div>';
				}
			}
		}
		
		$this->_displayForm();
		
		return $this->_html;
	}
	
	private function _displayForm()
	{
	
		$this->_html .= '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<legend><img src="../img/admin/cog.gif" alt="" class="middle" />'.$this->l('Settings').'</legend>
				<label>'.$this->l('Facebook Page Url').'</label>
				<div class="margin-form">
					<input size="60" type="text" name="url" value="'.Tools::getValue('url', Configuration::get('PLLB_URL')).'"/>
					<p class="clear">'.$this->l('The URL of the Facebook Page for this like box').'</p>
				</div>
		
				<label>'.$this->l('Color Scheme').'</label>
				<div class="margin-form">
					<select name = "color">
					<option value="light"'.(Tools::getValue('color', Configuration::get('PLLB_COLOR')) == "light" ? ' SELECTED' : '').' >Light</option>
					<option value="dark"'.(Tools::getValue('color', Configuration::get('PLLB_COLOR')) == "dark" ? ' SELECTED' : '').' >Dark</option>
					</select>
					<p class="clear">'.$this->l('The color scheme of the like box').'</p>
				</div>
				<label>'.$this->l('Border Color').'</label>
				<div class="margin-form">
					<input size="10" type="text" name="border" value="'.Tools::getValue('border', Configuration::get('PLLB_BORDER')).'"/>
					<p class="clear">'.$this->l('The border color of the like box. Using color code like FFF or FFFFFF').'</p>
				</div>
				<label>'.$this->l('Width').'</label>
				<div class="margin-form">
					<input size="10" type="text" name="width" value="'.Tools::getValue('width', Configuration::get('PLLB_WIDTH')).'"/>
					<p class="clear">'.$this->l('The width of like box in pixels').'</p>
				</div>
				<label>'.$this->l('Height').'</label>
				<div class="margin-form">
					<input size="10" type="text" name="height" value="'.Tools::getValue('height', Configuration::get('PLLB_HEIGHT')).'"/>
					<p class="clear">'.$this->l('The height of like box in pixels').'</p>
				</div>
							
				<label>'.$this->l('Use Locale').'</label>
				<div class="margin-form">
					<input type="checkbox" name="use_locale" value="'.(Tools::getValue('use_locale', Configuration::get('PLLB_USE_LOCALE')) ? "true" : "false").'"' .
					(Tools::getValue('use_locale', Configuration::get('PLLB_USE_LOCALE')) == "true" ? ' checked="checked"' : '') . ' />
					<p class="clear">'.$this->l('Use Locale. Select a specific locale below. If not, current site locale will be use').'</p>
				</div>
				<label>'.$this->l('Locale').'</label>
				<div class="margin-form">
					<select name = "locale">
						<option value="af_ZA"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "af_ZA" ? ' SELECTED' : '').' >Afrikaans</option>
						<option value="ar_AR"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ar_AR" ? ' SELECTED' : '').' >Arabic</option>
						<option value="ay_BO"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ay_BO" ? ' SELECTED' : '').' >Aymara</option>
						<option value="az_AZ"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "az_AZ" ? ' SELECTED' : '').' >Azeri</option>
						<option value="be_BY"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "be_BY" ? ' SELECTED' : '').' >Belarusian</option>
						<option value="bg_BG"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "bg_BG" ? ' SELECTED' : '').' >Bulgarian</option>
						<option value="bn_IN"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "bn_IN" ? ' SELECTED' : '').' >Bengali</option>
						<option value="bs_BA"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "bs_BA" ? ' SELECTED' : '').' >Bosnian</option>
						<option value="ca_ES"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ca_ES" ? ' SELECTED' : '').' >Catalan</option>
						<option value="ck_US"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ck_US" ? ' SELECTED' : '').' >Cherokee</option>
						<option value="cs_CZ"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "cs_CZ" ? ' SELECTED' : '').' >Czech</option>
						<option value="cy_GB"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "cy_GB" ? ' SELECTED' : '').' >Welsh</option>
						<option value="da_DK"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "da_DK" ? ' SELECTED' : '').' >Danish</option>
						<option value="de_DE"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "de_DE" ? ' SELECTED' : '').' >German</option>
						<option value="el_GR"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "el_GR" ? ' SELECTED' : '').' >Greek</option>
						<option value="en_GB"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "en_GB" ? ' SELECTED' : '').' >English (UK)</option>
						<option value="en_PI"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "en_PI" ? ' SELECTED' : '').' >English (Pirate)</option>
						<option value="en_UD"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "en_UD" ? ' SELECTED' : '').' >English (Upside Down)</option>
						<option value="en_US"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "en_US" ? ' SELECTED' : '').' >English [US]</option>
						<option value="eo_EO"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "eo_EO" ? ' SELECTED' : '').' >Esperanto</option>
						<option value="es_CL"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "es_CL" ? ' SELECTED' : '').' >Spanish (Chile)</option>
						<option value="es_CO"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "es_CO" ? ' SELECTED' : '').' >Spanish (Colombia)</option>
						<option value="es_ES"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "es_ES" ? ' SELECTED' : '').' >Spanish (Spain)</option>
						<option value="es_LA"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "es_LA" ? ' SELECTED' : '').' >Spanish</option>
						<option value="es_MX"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "es_MX" ? ' SELECTED' : '').' >Spanish (Mexico)</option>
						<option value="es_VE"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "es_VE" ? ' SELECTED' : '').' >Spanish (Mexico)</option>
						<option value="et_EE"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "et_EE" ? ' SELECTED' : '').' >Estonian</option>
						<option value="eu_ES"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "eu_ES" ? ' SELECTED' : '').' >Basque</option>
						<option value="fa_IR"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "fa_IR" ? ' SELECTED' : '').' >Persian</option>
						<option value="fb_LT"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "fb_LT" ? ' SELECTED' : '').' >Leet Speak</option>
						<option value="fi_FI"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "fi_FI" ? ' SELECTED' : '').' >Finnish</option>
						<option value="fo_FO"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "fo_FO" ? ' SELECTED' : '').' >Faroese</option>
						<option value="fr_CA"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "fr_CA" ? ' SELECTED' : '').' >French (Canada)</option>
						<option value="fr_FR"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "fr_FR" ? ' SELECTED' : '').' >French (France)</option>
						<option value="ga_IE"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ga_IE" ? ' SELECTED' : '').' >Irish</option>
						<option value="gl_ES"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "gl_ES" ? ' SELECTED' : '').' >Galician</option>
						<option value="gn_PY"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "gn_PY" ? ' SELECTED' : '').' >Guarani</option>
						<option value="gu_IN"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "gu_IN" ? ' SELECTED' : '').' >Gujarati</option>
						<option value="he_IL"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "he_IL" ? ' SELECTED' : '').' >Hebrew</option>
						<option value="hi_IN"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "hi_IN" ? ' SELECTED' : '').' >Hindi</option>
						<option value="hr_HR"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "hr_HR" ? ' SELECTED' : '').' >Croatian</option>
						<option value="hu_HU"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "hu_HU" ? ' SELECTED' : '').' >Hungarian</option>
						<option value="hy_AM"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "hy_AM" ? ' SELECTED' : '').' >Armenian</option>
						<option value="id_ID"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "id_ID" ? ' SELECTED' : '').' >Indonesian</option>
						<option value="is_IS"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "is_IS" ? ' SELECTED' : '').' >Icelandic</option>
						<option value="it_IT"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "it_IT" ? ' SELECTED' : '').' >Italian</option>
						<option value="ja_JP"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ja_JP" ? ' SELECTED' : '').' >Japanese</option>
						<option value="jv_ID"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "jv_ID" ? ' SELECTED' : '').' >Javanese</option>
						<option value="ka_GE"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ka_GE" ? ' SELECTED' : '').' >Georgian</option>
						<option value="kk_KZ"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "kk_KZ" ? ' SELECTED' : '').' >Kazakh</option>
						<option value="km_KH"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "km_KH" ? ' SELECTED' : '').' >Khmer</option>
						<option value="kn_IN"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "kn_IN" ? ' SELECTED' : '').' >Kannada</option>
						<option value="ko_KR"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ko_KR" ? ' SELECTED' : '').' >Korean</option>
						<option value="ku_TR"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ku_TR" ? ' SELECTED' : '').' >Kurdish</option>
						<option value="la_VA"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "la_VA" ? ' SELECTED' : '').' >Latin</option>
						<option value="li_NL"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "li_NL" ? ' SELECTED' : '').' >Limburgish</option>
						<option value="lt_LT"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "lt_LT" ? ' SELECTED' : '').' >Lithuanian</option>
						<option value="lv_LV"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "lv_LV" ? ' SELECTED' : '').' >Latvian</option>
						<option value="mg_MG"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "mg_MG" ? ' SELECTED' : '').' >Malagasy</option>
						<option value="mk_MK"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "mk_MK" ? ' SELECTED' : '').' >Macedonian</option>
						<option value="ml_IN"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ml_IN" ? ' SELECTED' : '').' >Malayalam</option>
						<option value="mn_MN"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "mn_MN" ? ' SELECTED' : '').' >Mongolian</option>
						<option value="mr_IN"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "mr_IN" ? ' SELECTED' : '').' >Marathi</option>
						<option value="ms_MY"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ms_MY" ? ' SELECTED' : '').' >Malay</option>
						<option value="mt_MT"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "mt_MT" ? ' SELECTED' : '').' >Maltese</option>
						<option value="nb_NO"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "nb_NO" ? ' SELECTED' : '').' >Norwegian (bokmal)</option>
						<option value="ne_NP"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ne_NP" ? ' SELECTED' : '').' >Nepali</option>
						<option value="nl_BE"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "nl_BE" ? ' SELECTED' : '').' >Dutch (Belgie)</option>
						<option value="nl_NL"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "nl_NL" ? ' SELECTED' : '').' >Dutch</option>
						<option value="nn_NO"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "nn_NO" ? ' SELECTED' : '').' >Norwegian (nynorsk)</option>
						<option value="pa_IN"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "pa_IN" ? ' SELECTED' : '').' >Punjabi</option>
						<option value="pl_PL"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "pl_PL" ? ' SELECTED' : '').' >Polish</option>
						<option value="ps_AF"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ps_AF" ? ' SELECTED' : '').' >Pashto</option>
						<option value="pt_BR"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "pt_BR" ? ' SELECTED' : '').' >Portuguese (Brazil)</option>
						<option value="pt_PT"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "pt_PT" ? ' SELECTED' : '').' >Portuguese (Portugal)</option>
						<option value="qu_PE"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "qu_PE" ? ' SELECTED' : '').' >Quechua</option>
						<option value="rm_CH"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "rm_CH" ? ' SELECTED' : '').' >Romansh</option>
						<option value="ro_RO"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ro_RO" ? ' SELECTED' : '').' >Romanian</option>
						<option value="ru_RU"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ru_RU" ? ' SELECTED' : '').' >Russian</option>
						<option value="sa_IN"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "sa_IN" ? ' SELECTED' : '').' >Sanskrit</option>
						<option value="se_NO"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "se_NO" ? ' SELECTED' : '').' >Northern Sami</option>
						<option value="sk_SK"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "sk_SK" ? ' SELECTED' : '').' >Slovak</option>
						<option value="sl_SI"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "sl_SI" ? ' SELECTED' : '').' >Slovenian</option>
						<option value="so_SO"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "so_SO" ? ' SELECTED' : '').' >Somali</option>
						<option value="sq_AL"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "sq_AL" ? ' SELECTED' : '').' >Albanian</option>
						<option value="sr_RS"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "sr_RS" ? ' SELECTED' : '').' >Serbian</option>
						<option value="sv_SE"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "sv_SE" ? ' SELECTED' : '').' >Swedish</option>
						<option value="sw_KE"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "sw_KE" ? ' SELECTED' : '').' >Swahili</option>
						<option value="sy_SY"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "sy_SY" ? ' SELECTED' : '').' >Syriac</option>
						<option value="ta_IN"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ta_IN" ? ' SELECTED' : '').' >Tamil</option>
						<option value="te_IN"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "te_IN" ? ' SELECTED' : '').' >Telugu</option>
						<option value="tg_TJ"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "tg_TJ" ? ' SELECTED' : '').' >Tajik</option>
						<option value="th_TH"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "th_TH" ? ' SELECTED' : '').' >Thai</option>
						<option value="tl_PH"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "tl_PH" ? ' SELECTED' : '').' >Filipino</option>
						<option value="tl_ST"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "tl_ST" ? ' SELECTED' : '').' >Klingon</option>
						<option value="tr_TR"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "tr_TR" ? ' SELECTED' : '').' >Turkish</option>
						<option value="tt_RU"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "tt_RU" ? ' SELECTED' : '').' >Tatar</option>
						<option value="uk_UA"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "uk_UA" ? ' SELECTED' : '').' >Ukrainian</option>
						<option value="ur_PK"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "ur_PK" ? ' SELECTED' : '').' >Urdu</option>
						<option value="uz_UZ"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "uz_UZ" ? ' SELECTED' : '').' >Uzbek</option>
						<option value="vi_VN"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "vi_VN" ? ' SELECTED' : '').' >Vietnamese</option>
						<option value="xh_ZA"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "xh_ZA" ? ' SELECTED' : '').' >Xhosa</option>
						<option value="yi_DE"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "yi_DE" ? ' SELECTED' : '').' >Yiddish</option>
						<option value="zh_CN"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "zh_CN" ? ' SELECTED' : '').' >Simplified Chinese (China)</option>
						<option value="zh_HK"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "zh_HK" ? ' SELECTED' : '').' >Traditional Chinese (Hong Kong)</option>
						<option value="zh_TW"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "zh_TW" ? ' SELECTED' : '').' >Traditional Chinese (Taiwan)</option>
						<option value="zu_ZA"'.(Tools::getValue('locale', Configuration::get('PLFA_LOCALE')) == "zu_ZA" ? ' SELECTED' : '').' >Zulu</option>
					</select>
					<p class="clear">'.$this->l('Locale').'</p>
				</div>
			<input type="submit" name="submit" value="'.$this->l('Update').'" class="button" />
			</fieldset>
		</form>';
	}
	
// -----------------------------------------------------------------	
	public function getFacebookID($name) {

		$facebookInfo = explode(",", file_get_contents('https://graph.facebook.com/'.$name));
		//print_r($facebookInfo);
		$waste = array("'{'", "'}'");
		foreach ($facebookInfo as $key => $info) {
			 $clrData = explode("\":\"", preg_replace($waste, "", $info));
			 foreach ($clrData as $k => $v) {
			 	$clr[$k] = preg_replace("'\"'", "", $v);
			 }
			 $facebookInfo[$key] = $clr;
		}
		if ($facebookInfo[0][1]) { 
			$id = $facebookInfo[0][1];
		} else {
			$id = "";
		}
		return $id;

	}

// Front Office Here			
	public function hookLeftColumn()
	{
		global $cookie;
		$this_path = "http://".$this->context->shop->domain.$this->context->shop->physical_uri."modules/".$this->name."/";
		$html = '';
		//$render = Configuration::get('PLLB_RENDERING');
		$locale = Configuration::get('PLLB_LOCALE');
		
		if (!Configuration::get('PLLB_USE_LOCALE'))
		{
			$locale = strtolower(Language::getIsoById($cookie->id_lang));
			if ($locale == "af")
				$locale = "af_ZA";
			elseif ($locale == "ar") $locale = "ar_AR";
			elseif ($locale == "ay") $locale = "ay_BO";
			elseif ($locale == "az") $locale = "az_AZ";
			elseif ($locale == "be") $locale = "be_BY";
			elseif ($locale == "bg") $locale = "bg_BG";
			elseif ($locale == "bn") $locale = "bn_IN";
			elseif ($locale == "bs") $locale = "bs_BA";
			elseif ($locale == "ca") $locale = "ca_ES";
			elseif ($locale == "ck") $locale = "ck_US";
			elseif ($locale == "cs") $locale = "cs_CZ";
			elseif ($locale == "cy") $locale = "cy_GB";
			elseif ($locale == "da") $locale = "da_DK";
			elseif ($locale == "de") $locale = "de_DE";
			elseif ($locale == "el") $locale = "el_GR";
			elseif ($locale == "en") $locale = "en_GB";
			elseif ($locale == "en") $locale = "en_PI";
			elseif ($locale == "en") $locale = "en_UD";
			elseif ($locale == "en") $locale = "en_US";
			elseif ($locale == "eo") $locale = "eo_EO";
			elseif ($locale == "es") $locale = "es_CL";
			elseif ($locale == "es") $locale = "es_CO";
			elseif ($locale == "es") $locale = "es_ES";
			elseif ($locale == "es") $locale = "es_LA";
			elseif ($locale == "es") $locale = "es_MX";
			elseif ($locale == "es") $locale = "es_VE";
			elseif ($locale == "et") $locale = "et_EE";
			elseif ($locale == "eu") $locale = "eu_ES";
			elseif ($locale == "fa") $locale = "fa_IR";
			elseif ($locale == "fb") $locale = "fb_LT";
			elseif ($locale == "fi") $locale = "fi_FI";
			elseif ($locale == "fo") $locale = "fo_FO";
			elseif ($locale == "fr") $locale = "fr_CA";
			elseif ($locale == "fr") $locale = "fr_FR";
			elseif ($locale == "ga") $locale = "ga_IE";
			elseif ($locale == "gl") $locale = "gl_ES";
			elseif ($locale == "gn") $locale = "gn_PY";
			elseif ($locale == "gu") $locale = "gu_IN";
			elseif ($locale == "he") $locale = "he_IL";
			elseif ($locale == "hi") $locale = "hi_IN";
			elseif ($locale == "hr") $locale = "hr_HR";
			elseif ($locale == "hu") $locale = "hu_HU";
			elseif ($locale == "hy") $locale = "hy_AM";
			elseif ($locale == "id") $locale = "id_ID";
			elseif ($locale == "is") $locale = "is_IS";
			elseif ($locale == "it") $locale = "it_IT";
			elseif ($locale == "ja") $locale = "ja_JP";
			elseif ($locale == "jv") $locale = "jv_ID";
			elseif ($locale == "ka") $locale = "ka_GE";
			elseif ($locale == "kk") $locale = "kk_KZ";
			elseif ($locale == "km") $locale = "km_KH";
			elseif ($locale == "kn") $locale = "kn_IN";
			elseif ($locale == "ko") $locale = "ko_KR";
			elseif ($locale == "ku") $locale = "ku_TR";
			elseif ($locale == "la") $locale = "la_VA";
			elseif ($locale == "li") $locale = "li_NL";
			elseif ($locale == "lt") $locale = "lt_LT";
			elseif ($locale == "lv") $locale = "lv_LV";
			elseif ($locale == "mg") $locale = "mg_MG";
			elseif ($locale == "mk") $locale = "mk_MK";
			elseif ($locale == "ml") $locale = "ml_IN";
			elseif ($locale == "mn") $locale = "mn_MN";
			elseif ($locale == "mr") $locale = "mr_IN";
			elseif ($locale == "ms") $locale = "ms_MY";
			elseif ($locale == "mt") $locale = "mt_MT";
			elseif ($locale == "nb") $locale = "nb_NO";
			elseif ($locale == "ne") $locale = "ne_NP";
			elseif ($locale == "nl") $locale = "nl_BE";
			elseif ($locale == "nl") $locale = "nl_NL";
			elseif ($locale == "nn") $locale = "nn_NO";
			elseif ($locale == "pa") $locale = "pa_IN";
			elseif ($locale == "pl") $locale = "pl_PL";
			elseif ($locale == "ps") $locale = "ps_AF";
			elseif ($locale == "pt") $locale = "pt_BR";
			elseif ($locale == "pt") $locale = "pt_PT";
			elseif ($locale == "qu") $locale = "qu_PE";
			elseif ($locale == "rm") $locale = "rm_CH";
			elseif ($locale == "ro") $locale = "ro_RO";
			elseif ($locale == "ru") $locale = "ru_RU";
			elseif ($locale == "sa") $locale = "sa_IN";
			elseif ($locale == "se") $locale = "se_NO";
			elseif ($locale == "sk") $locale = "sk_SK";
			elseif ($locale == "sl") $locale = "sl_SI";
			elseif ($locale == "so") $locale = "so_SO";
			elseif ($locale == "sq") $locale = "sq_AL";
			elseif ($locale == "sr") $locale = "sr_RS";
			elseif ($locale == "sv") $locale = "sv_SE";
			elseif ($locale == "sw") $locale = "sw_KE";
			elseif ($locale == "sy") $locale = "sy_SY";
			elseif ($locale == "ta") $locale = "ta_IN";
			elseif ($locale == "te") $locale = "te_IN";
			elseif ($locale == "tg") $locale = "tg_TJ";
			elseif ($locale == "th") $locale = "th_TH";
			elseif ($locale == "tl") $locale = "tl_PH";
			elseif ($locale == "tl") $locale = "tl_ST";
			elseif ($locale == "tr") $locale = "tr_TR";
			elseif ($locale == "tt") $locale = "tt_RU";
			elseif ($locale == "uk") $locale = "uk_UA";
			elseif ($locale == "ur") $locale = "ur_PK";
			elseif ($locale == "uz") $locale = "uz_UZ";
			elseif ($locale == "vi") $locale = "vi_VN";
			elseif ($locale == "xh") $locale = "xh_ZA";
			elseif ($locale == "yi") $locale = "yi_DE";
			elseif ($locale == "zh") $locale = "zh_CN";
			elseif ($locale == "zh") $locale = "zh_HK";
			elseif ($locale == "zh") $locale = "zh_TW";
			elseif ($locale == "zu") $locale = "zu_ZA";
			else
				$locale = "en_US";
		}

		$url = Configuration::get('PLLB_URL');
		$width = Configuration::get('PLLB_WIDTH');
		$height = Configuration::get('PLLB_HEIGHT');
		$border = Configuration::get('PLLB_BORDER');
		$faces = Configuration::get('PLLB_FACES');

		//$url = explode("/", $url);
		//$url_name = array_reverse($url);
		//$id = $this->getFacebookID($url_name[0]);		
			$html= '
			<div class="facebook_block block">
				<h4>Facebook</h4>
				<div class="facebookBody">
					<iframe 
					src="https://www.facebook.com/plugins/fan.php?href='.$url.'&amp;locale='.$locale.'&amp;width='.$width.'&amp;height='.$height.'&amp;border_color=%23'.$border.'&amp;show_faces=true&amp;stream=false&amp;header=false&amp;css='.$this_path.'facebook.css.php?223"
					scrolling="no" 
					frameborder="0" 
					style="border:none; 
					overflow:hidden; 
					width:'.$width.'px;
					height:'.$height.'px" 
					allowTransparency="true">
					</iframe>
				</div>
			</div>
			';		
		
		return $html;

		
	}
	
		
	public function hookRightColumn($params)
	{
		return $this->hookLeftColumn($params);
	}

	public function hookFooter($params)
	{
		return $this->hookLeftColumn($params);
	}

		
}

